<?php

namespace App\Observers;

use App\Models\Service;
use App\Services\Seo\BuildSitemapService;

class ServiceObserver
{
    public function saved(Service $service)
    {
        app(BuildSitemapService::class)->generateSitemap();
    }

    public function deleting(Service $service)
    {
        // Optional: تنفيذ شيء قبل الحذف
    }

    public function deleted(Service $service)
    {
        app(BuildSitemapService::class)->generateSitemap();
    }

    public function forceDeleted(Service $service)
    {
        app(BuildSitemapService::class)->generateSitemap();
    }
}


