<?php





/**


 * Session class


 *


 * this class contain the methods that deals with session


 *


 *


 * LICENSE: Open source


 *


 * @category   general


 * @package    core system


 * @subpackage parent


 * @copyright  coderg


 * @license    http://coderg.com


 * @version    .01


 * @link       http://coderg.com


 * @since      2018


 */


class Session {





    // declare array of sesssions 


    private $sessions = array();





    //constructor 


    public function __construct($sessions = "") {


        $this->sessions = $sessions;


    }





    /**


     * setSession


     *


     * set session


     *


     * @param    none


     * @return   none


     *


     */


    public function setSession() {


        $this->startSession();


        if(is_array($this->sessions))


        {


            foreach ($this->sessions as $sessionName => $sessionValue)


            {


                $_SESSION[$sessionName] = $sessionValue;


            }


            return TRUE;


        }


        return FALSE;


    }





    /**


     * startSession


     *


     * start session if no session found


     *


     * @param    none


     * @return   none


     *


     */


    public function startSession() {


        if (session_id() == NULL) {


            session_start();


        }


    }





    /**


     * getSession


     *


     * get value of a specific session


     *


     * @param  $seesionnName  (string)


     * @return   (string) session value


     *


     */


    public function getSession($sessionName) {


        $this->startSession();


        return (isset($_SESSION[$sessionName]))?$_SESSION[$sessionName]: NULL;


    }





    /**


     * hasSession


     *


     * check if there is a session with this name or not


     *


     * @param  $sessionName (string)


     * @return   (boolean)


     *


     */


    public function hasSession($sessionName) {


        $this->startSession();


        if (isset($_SESSION[$sessionName])) {


            return TRUE;


        } else {


            return FALSE;


        }


    }





    /**


     * unsetSession


     *


     * unset a specific session


     *


     * @param  $sessionName (string)


     * @return   none


     *


     */


    public  function unsetSession($sessionName) {


        if ($this->hasSession($sessionName)) {


            unset($_SESSION[$sessionName]);


            return TRUE;


        }


        return FALSE;


    }





    /**


     * destroySession


     *


     * destory sessions


     *


     * @param   none


     * @return  none


     *


     */


    public function destroySession() {


        $this->startSession();


        if(session_destroy())


        {


            return TRUE;


        }


        return FALSE;


    }





}


