<?php

class Offer extends Controller
{

    private function getSEO()
    {
        $url = parse_url($_SERVER['REQUEST_URI']);
        $slug = $url['path'];
        $result = $this->loadModel("SeoModel")->retrieveAllData("WHERE `slug` =? ", array($slug));
        if($result && count($result)) {
            $seo = $result[0];
        } else {
            $seo = [
                'slug' => null,
                'title' => null,
                'keywords' => null,
                'content' => null
            ];
        }

        return $seo;
    }

    public function view()

    {
        $dataView['SEO'] = $this->getSEO();
        $dataView['current'] = "offers";
        $id = (int)$this->loadRoute()->getSegment(2);
        if ($id == 0) {
            $this->redirect("error", "index");
            exit();
        }

        // offer
        $dataView['offer'] = $this->loadModel("OfferModel")->retrieveAllData("WHERE  `id` =?  AND `status` =? AND `deleted` =? ", array($id, 1, 1));
        if (!is_array($dataView['offer'])) {
            $this->redirect("error", "index");
            exit();
        }
        $dataView['offer'] = array_shift($dataView['offer']);
        $dataView['offerLang'] = $this->loadModel("OfferEnModel")->retriveDataById("id_offer", $id);
        $dataView['categoryLang'] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category", $dataView['offer']['id_category']);
        // offer images
        $dataView['offerImages'] = $this->loadModel("OfferImagesModel")->retrieveAllData("WHERE  `id_offer` =?  AND `status` =? AND `deleted` =?", array($id, 1, 1));


        // set page title
        $dataView['title'] = "Eg  |   " . $dataView['offerLang']['title'];
        // global Template Config
        global $TEMPLATE_FRONT_END;
        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "offers_details";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }



}

?>
