<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <?php
            echo isset($title) ? $title : NULL;
            ?>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-lg-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title ">Show / Edit Client</h3>
                        <a class="btn btn-primary pull-right" href="<?php echo BASE_URL . "gallery/add" ?>"><i
                                    class="fa fa-plus" aria-hidden="true"></i> Add a New Client</a>
                    </div>
                    <!-- /.box-header -->
                    <div class="adminform">
                        <div class="text-center">
                            <span onclick="exportToexcel('#all_data')" class="btn btn-success export-btn">Export To Excel</span>
                        </div>
                        <!-- form start -->
                        <table id="all_data"
                               class="table table_for_data table-striped table-bordered dt-responsive nowrap tableData tableForAllData"
                               cellspacing="0" width="100%">
                            <thead>
                            <tr>
                                <th>Id</th>
                                <th>Image</th>
                                <th>Date</th>
                                <th>status</th>
                                <th>action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            if (isset($gallerys) && is_array($gallerys)) {
                                foreach ($gallerys as $key => $data) {
                                    echo '<tr id="row' . $data['id'] . '">
                                                    <td>' . $data['id'] . '</td>
                            	                    <td><img src="' . UPLOAD_LINK . $data['image'] . '" data-id="' . $data['id'] . '" data-toggle="modal" data-target="#update-img" alt="" title="Edit Image" class="img-rounded img-responsive center-block img-edit imagenumber' . $data['id'] . '" /></td>
                                                    <td>' . $data['createdAt'] . '</td>
                                                 ';

                                    echo '</td>
                                                    <td>';
                                    if ($data['status'] == 1) {
                                        echo '<span data-id="' . $data['id'] . '" title="update Status" data-target="on" class="status on update' . $data['id'] . '">on</span>';
                                    } else {
                                        echo '<span data-id="' . $data['id'] . '" title="update Status" data-target="off" class="status off update' . $data['id'] . '">off</span>';
                                    }
                                    echo '</td>
                                                    <td>
                                                        <ul class="actions">
                                                         <li><a href="" data-toggle="modal" data-id="' . $data['id'] . '" data-target="#deleteModal" class="deleteIcon" title="Delete"><i class="fa fa-trash" aria-hidden="true"></i>  </a></li>
                                                        </ul>
                                                    </td>
                                                  </tr>';
                                }
                            } else {
                                echo '<tr><td colspan="5">No Data Found</td></tr>';
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.box -->
            </div>
        </div>
    </section><!-- /.content -->
</div><!-- /.content-wrapper -->

<!-- Start Delete Modal -->
<div class="modal fade" id="deleteModal" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Confirm delete Your Data</h4>
            </div>
            <div class="modal-body">
                <div id="deleteResult"></div>
                <p>Are You Sure ? </p>
                <input type="submit" class="btn btn-primary del" name="delete" value="Delete"/>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!--End Delete Modal-->

<!-- Start edit Image Modal -->
<div class="modal fade" id="update-img" role="dialog">
    <div class="modal-dialog modal-md">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Edit Image</h4>
            </div>
            <div class="modal-body">
                <div id="updateImageResult"></div>
                <div class="row">
                    <div class="col-lg-9 pull-left">
                        <form id="updateImage" method="post" enctype="multipart/form-data">
                            <div class="form-group">
                                <label for="category-image"> Image</label>
                                <input type="file" name="image_name" id="image-file">
                                <p class="help-block">Choose Image.</p>
                            </div>
                            <input type="hidden" value="" class="field_id" name="field_id"/>
                            <input type="submit" class="btn btn-primary updatebtn" name="editImage" value="Save"/>
                            <span class="loadingImage">
					  	<img src="../../../../../index.php"/>
					  </span>
                        </form>
                    </div>
                    <div class="col-lg-3 pull-right">
                        <img src="" alt="" title="Edit Image" class="img-responsive old-image"/>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!--End Edit Image Modal-->

<script>
    $(document).ready(function () {
        // start edit image
        $(".table_for_data").on('click', '.img-edit', function () {
            $("#updateImageResult").html("");
            // get id for update
            var myId = $(this).attr("data-id");
            // get image
            var image = $(this).attr("src");
            // set image into model
            $(".old-image").attr("src", image);
            // set  id in hidden input
            $(".field_id").attr("value", myId);
            $("#updateImage").submit(function () {
                $.ajax({
                    url: "<?php echo BASE_URL . "gallery/update_image"; ?>",
                    type: "POST",
                    data: new FormData(this), // Data sent to server, a set of key/value pairs (i.e. form fields and values)
                    contentType: false,       // The content type used when sending data to the server.
                    processData: false,
                    beforeSend: function () {
                        $(".loadingImage").show();
                    },
                    statusCode: {
                        404: function () {
                            alert("page not found");
                        },
                    },
                    success: function (valdata) {
                        $(".loadingImage").hide();
                        var da = jQuery.parseJSON(valdata);
                        if (da['status'] == "success") {
                            $("#updateImageResult").html('<div class="alert alert-success" role="alert"><strong>Success </strong> Image Updated Successfuly </div>');
                            $('#update-img').modal('hide')
                            // get image row id to change image when success
                            var filedId = $(".field_id").val();
                            $('.imagenumber' + filedId).attr("src", "<?php echo UPLOAD_LINK; ?>" + da['newImage']);

                        } else {
                            $("#updateImageResult").html('<div class="alert alert-danger" role="alert"><strong> Error ! </strong> Error Update Your Image (Not Allowed Image Extension Or You Did Not Choose Image)</div>');
                        }
                    }
                });
                return false;
            });
        });
        // end edit image
        // start delete
        $(".table_for_data").on('click', '.deleteIcon', function () {
            $("#deleteResult").html("");
            var myId = $(this).attr("data-id");
            var myaction = "deleteData";
            var allData = {"action": myaction, "id": myId};
            $(".del").click(function () {
                $.ajax({
                    url: "<?php echo BASE_URL . 'gallery/delete' ?>",
                    type: "POST",
                    data: allData,
                    beforeSend: function () {
                    },
                    statusCode: {
                        404: function () {
                            alert("page not found");
                        },
                    },
                    success: function (valdata) {
                        var da = jQuery.parseJSON(valdata);
                        if (da['status'] == "success") {
                            $("#deleteResult").html('<div class="alert alert-success" role="alert"><strong>Success </strong> Data Deleted Successfuly </div>');
                            $('#deleteModal').modal('hide')
                            $("#row" + myId).fadeOut(1000);
                        } else {
                            $("#deleteResult").html('<div class="alert alert-danger" role="alert"><strong> Error ! </strong> Error Deleting  Your Data </div>');
                        }
                    }
                });
                return false;
            });
        });
        // end delete
        //start update  status
        $(".table_for_data").on('click', '.status', function () {
            var myId = $(this).attr("data-id");
            var myaction = "updateStatus";
            var mystatus = $(this).attr("data-target");
            var allData = {"action": myaction, "id": myId, "status": mystatus};
            $.ajax({
                url: "<?php echo BASE_URL . 'gallery/updateStatus' ?>",
                type: "POST",
                data: allData,
                beforeSend: function () {
                },
                statusCode: {
                    404: function () {
                        alert("page not found");
                    },
                },
                success: function (valdata) {
                    var da = JSON.parse(valdata);
                    if (da['status'] == "success") {
                        if (mystatus == "on") {
                            $(".update" + myId).removeClass("on");
                            $(".update" + myId).html("off");
                            $(".update" + myId).addClass("off");
                            $(".update" + myId).attr("data-target", "off");
                        } else {
                            $(".update" + myId).removeClass("off");
                            $(".update" + myId).html("on");
                            $(".update" + myId).addClass("on");
                            $(".update" + myId).attr("data-target", "on");
                        }
                    } else {
                        alert("faild");
                    }
                }
            });
            return false;
        });

        //end update status

    });
</script>
