<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
             <?php
               echo isset($title) ? $title : NULL;
             ?>
          </h1>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-lg-12">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                          <h3 class="box-title ">Edit Product Images</h3>
                          <a class="btn btn-primary pull-right addImagesClick" data-toggle="modal"  data-target="#addImagesModal"><i class="fa fa-plus" aria-hidden="true"></i> Add More Images</a>
                        </div>
                        <!-- /.box-header -->
                        <div class="adminform">
                            <div class="row top-margin">
                                <div class="col-xs-12 deleteResult"></div>
                                <?php
                                   if(isset($offerImages) && is_array($offerImages))
                                   {
                                       foreach($offerImages as $image)
                                       {
                                            echo'
                                                  <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12 imgnum'.$image['id'].'">
                                                    <div class="albumImageContainer">
                                                          <p class="thumbnail">
                                                             <img src="'.UPLOAD_LINK.$image['image'].'"  class="img-responsive albumImg">
                                                          </p>
                                                          <i title="Delete" class="fa fa-times deleteAlbumImage" data-id="'.$image['id'].'" aria-hidden="true"></i>
                                                    </div>
                                                   </div>
                                                ';
                                        }
                                   }else{
                                       echo '<div class="col-xs-12"><div class="alert alert-info" role="alert"><strong>No Data Found</strong></div></div>';
                                   }
                                ?>
                              </div>

                        </div>
                      </div>
                      <!-- /.box -->
                </div>
            </div>
      </section><!-- /.content -->
</div><!-- /.content-wrapper -->

<!-- Start add album Image Modal -->
<div class="modal fade" id="addImagesModal" role="dialog">
   <div class="modal-dialog modal-lg">
      <!-- Modal content-->
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Add Images To Offer</h4>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-lg-12">
                  <div id="addImageResult"></div>
                  <form  id="addImgForm" method="post" enctype="multipart/form-data">
                     <div class="form-group">
                        <label for="album-image">Select Image</label>
                        <input type="file" name="images[]" id="image" multiple="multiple"/>
                     </div>
                      <input type="hidden" value="<?php echo $offer['id'] ?>" name="id_offer" />
                     <input type="submit" class="btn btn-primary addMoreImg" name="addImage" value="Add" />
                    <span class="loadingImage">
					  	<img src="customize\backend\images\Preloader_61.gif" />
					  </span>
                   </form>
               </div>
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
         </div>
      </div>
   </div>
</div>
<!--End add album Image Modal-->
 <script>
    $("document").ready(function(){
        // start add images to album
           $(".addImagesClick").click(function(){
             $("#addImageResult").html("");
             $("#addImgForm").submit(function(){
                $.ajax({
                    url: "<?php echo BASE_URL.'Offer/offer_add_more_images'; ?>",
                    type:"POST",
                    data: new FormData(this), // Data sent to server, a set of key/value pairs (i.e. form fields and values)
                    contentType: false,       // The content type used when sending data to the server.
                    processData:false,
                    beforeSend:function(){
                        $(".loadingImage").show();
                    },
                    statusCode: {
                     404: function() {
                       alert( "page not found" );
                      },
                      },
                      success:function(valdata) {
                         var da = jQuery.parseJSON(valdata);
                        if(da['status'] == "success")
                        {
                            $(".loadingImage").hide();
                          $("#addImageResult").html('<div class="alert alert-success" role="alert"><strong>Success </strong> Your Data Updated Successfully Please Wait ...</div>');
                          window.setTimeout('location.reload()', 2000)

                        }else if(da['status'] == "Somefaild"){
                          $("#addImageResult").html('<div class="alert alert-warning" role="alert"><strong> Warning ! </strong> Some Images Not Be Uploaded (Max Size : 5MB & Allowed Extensions : png - jpg - jpeg) </div>');
                        }else{
                          $("#addImageResult").html('<div class="alert alert-danger" role="alert"><strong> Error ! </strong> Can Not Update Your Data Please Select Some Images(Max Size : 5MB & Allowed Extensions : png - jpg - jpeg)</div>');
                        }
                      }
                });
                return false;
             });

           });
         // end add images to album
        // start image delete
         $(".deleteAlbumImage").click(function(){

             var myimageId = $(this).attr("data-id");
             var myaction = "deleteImage";
             var allData = {"action":myaction,"imageId":myimageId};
                 $.ajax({
                    url: "<?php echo BASE_URL.'Offer/delete_offer_images' ?>",
                    type:"POST",
                    data: allData,
                    beforeSend:function(){
                    },
                    statusCode: {
                     404: function() {
                       alert( "page not found" );
                        },
                    },
                    success:function(valdata) {
                        var da = jQuery.parseJSON(valdata);
                        if(da['status'] == "success")
                        {
                           $(".imgnum"+myimageId).fadeOut(1000);
                        }else{
                          $("#deleteResult").html('<div class="alert alert-danger" role="alert"><strong> Error ! </strong> Error Deleting  Image </div>');
                        }
                    }
                });
                return false;
         });
         // end image delete
      });
</script>

