<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <?php
            echo isset($title) ? $title : NULL;
            ?>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <form method="post" enctype="multipart/form-data">
                <div class="col-lg-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Edit Selected Product</h3>
                            <a class="btn btn-primary pull-right"
                               href="<?php echo BASE_URL . "offer/edit_images/" . $offer['id'] ?>"><i class="fa fa-edit"
                                                                                                      aria-hidden="true"></i>
                                Edit Product Images</a>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->

                        <?php
                        if (isset($message)) {
                            echo $message;
                        }
                        ?>

                        <div class="box-body">
                            <div class="form-group">
                                <label class="set-block">Main Category</label>
                                <select name="id_category" class="form-control chosen main_category_select">
                                    <option value="0"> Choose Main Category</option>
                                    <?php

                                    if (isset($allCategories) && is_array($allCategories)) {
                                        foreach ($allCategories as $key => $data) {
                                            if ($data['id'] == $offer['id_category']) {
                                                echo '<option selected value=' . $data['id'] . '>' . $allCategoriesEn[$key]['title'] . "-" . $allCategoriesAr[$key]['title'] . '</option>';
                                            } else {
                                                echo '<option value=' . $data['id'] . '>' . $allCategoriesEn[$key]['title'] . "-" . $allCategoriesAr[$key]['title'] . '</option>';
                                            }
                                        }
                                    } else {
                                        echo '<option value="0">No Data Found</option>';
                                    }
                                    ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>Product Title</label>
                                <input id="" value="<?php echo $offerEnData['title']; ?>" name="title" type="text"
                                       class="form-control" placeholder="Product Title">
                            </div>
                            <div class="form-group">
                                <label>Product Slug</label>
                                <textarea name="slug"
                                          class="form-control"><?php echo $offerEnData['slug']; ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>Product Description</label>
                                <textarea name="description" rows="8"
                                          class="form-control"><?php echo $offerEnData['description']; ?></textarea>

                                <script>
                                    CKEDITOR.replace('description');

                                    function CKupdate() {
                                        for (instance in CKEDITOR.instances)
                                            CKEDITOR.instances[instance].updateElement();
                                    }
                                </script>
                            </div>


                            <div class="form-group">
                                <label for="availability" class="set-block">Status</label>
                                <div class="radio radio-info  radio-inline">
                                    <input type="radio" id="inlineRadio1" value="1"
                                           name="status" <?php if ($offer['status'] == 1) echo "checked"; ?>>
                                    <label for="inlineRadio1"> Active </label>
                                </div>
                                <div class="radio radio-info  radio-inline">
                                    <input type="radio" id="inlineRadio2" value="2"
                                           name="status" <?php if ($offer['status'] == 2) echo "checked"; ?>>
                                    <label for="inlineRadio2"> Not Active </label>
                                </div>
                            </div>

                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer">
                            <button type="submit" name="edit" class="btn btn-primary">Edit</button>
                        </div>

                    </div>
                    <!-- /.box -->
                </div>
                <div class="col-lg-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">تعديل المنتج</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->

                        <div class="box-body">

                            <div class="form-group">
                                <label>عنوان المنتج</label>
                                <input id="" value="<?php echo $offerArData['title']; ?>" name="title_ar" type="text"
                                       class="form-control" placeholder="عنوان المنتج">
                            </div>
                            <div class="form-group">
                                <label>مختصر المنتج</label>
                                <textarea name="slug_ar"
                                          class="form-control"><?php echo $offerArData['slug']; ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>وصف المنتج</label>
                                <textarea name="description_ar" rows="8"
                                          class="form-control"><?php echo $offerArData['description']; ?></textarea>

                                <script>
                                    CKEDITOR.replace('description_ar');

                                    function CKupdate() {
                                        for (instance in CKEDITOR.instances)
                                            CKEDITOR.instances[instance].updateElement();
                                    }
                                </script>
                            </div>
                        </div>
                        <!-- /.box-body -->

                    </div>
                    <!-- /.box -->
                </div>
            </form>
        </div>
    </section><!-- /.content -->
</div><!-- /.content-wrapper -->
