<?php

class Aboutus extends Controller
{

    public function edit()
    {
        //******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("error", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/
        if (isset($_POST['edit'])) {
            // preparing validation array
            $DataValid = array(
                "description" => array(
                    "value" => $_POST['description'],
                    "errorName" => "About Us Description",
                    "rules" => "min-length[4]"
                ),
                "description_ar" => array(
                    "value" => $_POST['description_ar'],
                    "errorName" => "وصفنا",
                    "rules" => "min-length[4]"
                ),
                "our_mission" => array(
                    "value" => $_POST['our_mission'],
                    "errorName" => " Our Factories  Description",
                    "rules" => "min-length[4]"
                ),
                "our_mission_ar" => array(
                    "value" => $_POST['our_mission_ar'],
                    "errorName" => "وصف  مصانعنا ",
                    "rules" => "min-length[4]"
                ),
                "our_vision" => array(
                    "value" => $_POST['our_vision'],
                    "errorName" => "Why Description",
                    "rules" => "min-length[4]"
                ),
                "our_vision_ar" => array(
                    "value" => $_POST['our_vision_ar'],
                    "errorName" => "وصف لماذا ",
                    "rules" => "min-length[4]"
                ),

            );
            // load validation class and pass validation data
            $validationResult = $this->loadValidation($DataValid)->formValidate();
            // check if the data is ok
            if (is_array($validationResult) && array_key_exists("success", $validationResult)) {
                // preparing data model
                $dataModel['last_update_by'] = $user_id;
                // load model and Add data
                if (FALSE !== $this->loadModel("AboutusModel", $dataModel)->updateData("id", 1)) {
                    // preparing lang data
                    $dataModelEn['description'] = $validationResult['success']['description'];
                    $dataModelEn['our_mission'] = $validationResult['success']['our_mission'];
                    $dataModelEn['our_vision'] = $validationResult['success']['our_vision'];
                    $this->loadModel("AboutusEnModel", $dataModelEn)->updateData("id_about_us", 1);
                    // ang ar
                    $dataModelAr['description'] = $validationResult['success']['description_ar'];
                    $dataModelAr['our_mission'] = $validationResult['success']['our_mission_ar'];
                    $dataModelAr['our_vision'] = $validationResult['success']['our_vision_ar'];
                    $this->loadModel("AboutusArModel", $dataModelAr)->updateData("id_about_us", 1);

                    $dataView['message'] = '<div class="alert alert-success" role="alert"><strong><i class="fa fa-check" aria-hidden="true"></i> success </strong> Your Data Updated Successfuly Please Wait ... </div>';
                    header("Refresh: 2");
                } else {
                    $dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data</div>';
                }

            } else {
                $dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $validationResult. '</div>';
            }
        }

        // get page date
        $page = $this->loadModel("AboutusModel")->retrieveAllData();
        if ($page != NULL) {
            $dataView['page'] = array_shift($page);
            $dataView['page_en'] = $this->loadModel("AboutusEnModel")->retriveDataById("id_about_us", 1);
            $dataView['page_ar'] = $this->loadModel("AboutusArModel")->retriveDataById("id_about_us", 1);
        } else {
            $this->redirect("error", "index");
            exit;
        }

        // set page title
        $dataView['title'] = "Edit About Us Page Data";
        // global TEMPLATE_BACK_END
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "aboutus" . DIRECTORY_SEPARATOR . "aboutus_edit";
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

    public function update_image()
    {
        $upload = $this->loadUpload("image_name")->do_upload();
        // check if there is error on image
        if (array_key_exists("uploadError", $upload)) {
            echo $this->loadAjax()->DataToJson(array("status" => "falid", "message" => $upload['uploadError']));
            exit;
        } else {
            $dataModel['image'] = $upload['uploaded'][0];
            if (false !== $this->loadModel("AboutusModel", $dataModel)->updateData("id", 1)) {
                echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['image']));
                exit;
            } else {
                echo $this->loadAjax()->DataToJson(array("status" => "falid"));
                exit;
            }
        }
    }

    public function mission_image()
    {
        $upload = $this->loadUpload("mission_image")->do_upload();
        // check if there is error on image
        if (array_key_exists("uploadError", $upload)) {
            echo $this->loadAjax()->DataToJson(array("status" => "falid", "message" => $upload['uploadError']));
            exit;
        } else {
            $dataModel['mission_image'] = $upload['uploaded'][0];
            if (false !== $this->loadModel("AboutusModel", $dataModel)->updateData("id", 1)) {
                echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['mission_image']));
                exit;
            } else {
                echo $this->loadAjax()->DataToJson(array("status" => "falid"));
                exit;
            }
        }
    }

    public function vision_image()
    {
        $upload = $this->loadUpload("vision_image")->do_upload();
        // check if there is error on image
        if (array_key_exists("uploadError", $upload)) {
            echo $this->loadAjax()->DataToJson(array("status" => "falid", "message" => $upload['uploadError']));
            exit;
        } else {
            $dataModel['vision_image'] = $upload['uploaded'][0];
            if (false !== $this->loadModel("AboutusModel", $dataModel)->updateData("id", 1)) {
                echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['vision_image']));
                exit;
            } else {
                echo $this->loadAjax()->DataToJson(array("status" => "falid"));
                exit;
            }
        }
    }

    public function value_image()
    {
        $upload = $this->loadUpload("value_image")->do_upload();
        // check if there is error on image
        if (array_key_exists("uploadError", $upload)) {
            echo $this->loadAjax()->DataToJson(array("status" => "falid", "message" => $upload['uploadError']));
            exit;
        } else {
            $dataModel['value_image'] = $upload['uploaded'][0];
            if (false !== $this->loadModel("AboutusModel", $dataModel)->updateData("id", 1)) {
                echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['value_image']));
                exit;
            } else {
                echo $this->loadAjax()->DataToJson(array("status" => "falid"));
                exit;
            }
        }
    }

    public function aboutus_gallery()
    {
        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("error", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/

        // get aboutus images
        $dataView['aboutus_gallery'] = $this->loadModel("AboutusImagesModel")->retrieveAllData("WHERE `status` =? AND `deleted` = ?", array(1, 1));


        // set page title
        $dataView['title'] = "Show Aboutus Images";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "aboutus" . DIRECTORY_SEPARATOR . "aboutus_gallery";
        // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

    public function aboutus_add_more_images()
    {
        $user_id = $this->loadSession()->getSession("user_id");
        // upload images
        $upload = $this->loadUpload("images")->do_upload();
        $counter = 0;
        foreach ($upload['uploaded'] as $value) {

            //preparing data to be sent to model
            $albumImagesData['created_by'] = $user_id;
            $albumImagesData['last_update_by'] = $user_id;
            $albumImagesData['createdAt'] = date('Y-m-d h:i:s');
            $albumImagesData['image'] = $value;
            // load Model To Add Images Name
            if ($this->loadModel("AboutusImagesModel", $albumImagesData)->add()) {
                $counter++;
            }
        }
        if ($counter == 0) {
            echo $this->loadAjax()->DataToJson(array("status" => "faild"));
            exit;
        } else if ($counter < count($upload['uploaded'])) {
            echo $this->loadAjax()->DataToJson(array("status" => "Somefaild"));
            exit;
        } else {
            echo $this->loadAjax()->DataToJson(array("status" => "success"));
            exit;
        }
    }

    public function delete_aboutus_images()
    {
        if (isset($_POST['action'], $_POST['imageId']) && $_POST['action'] == "deleteImage") {

            // get image id
            $image_id = (int)$_POST['imageId'];

            if ($image_id == 0) {
                echo $this->loadAjax()->DataToJson(array("status" => "faild"));
                exit;
            } else {

                if (false !== $this->loadModel("AboutusImagesModel", array("deleted" => 2))->updateData("id", $image_id)) {
                    echo $this->loadAjax()->DataToJson(array("status" => "success"));
                    exit;
                } else {
                    echo $this->loadAjax()->DataToJson(array("status" => "faild"));
                    exit;
                }
            }
        }
    }
}

?>
