<?php if($paginator->hasPages()): ?>
    <nav role="navigation" aria-label="Pagination Navigation" class="pagination-nav">
        
        <?php if($paginator->onFirstPage()): ?>
            <span class="nav-button disabled">
                <i class="fas fa-chevron-left"></i>
                <?php echo e(__('website.pagination.previous')); ?>

            </span>
        <?php else: ?>
            <a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" class="nav-button">
                <i class="fas fa-chevron-left"></i>
                <?php echo e(__('website.pagination.previous')); ?>

            </a>
        <?php endif; ?>

        
        <ul class="pagination">
            
            <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                
                <?php if(is_string($element)): ?>
                    <li class="disabled" aria-disabled="true">
                        <span><?php echo e($element); ?></span>
                    </li>
                <?php endif; ?>

                
                <?php if(is_array($element)): ?>
                    <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($page == $paginator->currentPage()): ?>
                            <li class="active" aria-current="page">
                                <span><?php echo e($page); ?></span>
                            </li>
                        <?php else: ?>
                            <li>
                                <a href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

        
        <?php if($paginator->hasMorePages()): ?>
            <a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" class="nav-button">
                <?php echo e(__('website.pagination.next')); ?>

                <i class="fas fa-chevron-right"></i>
            </a>
        <?php else: ?>
            <span class="nav-button disabled">
                <?php echo e(__('website.pagination.next')); ?>

                <i class="fas fa-chevron-right"></i>
            </span>
        <?php endif; ?>
    </nav>
<?php endif; ?>
<?php /**PATH /home/webtest3/public_html/dhi/resources/views/vendor/pagination/custom.blade.php ENDPATH**/ ?>