<!-- SEO Component - This includes all meta tags, title, hreflang, and schema -->
<?php if(isset($metatags) && isset($schema)): ?>
    <?php if (isset($component)) { $__componentOriginalaac5c311a1def36561cfafc293b5015f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaac5c311a1def36561cfafc293b5015f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.seo.head','data' => ['metatags' => $metatags,'schema' => $schema]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('seo.head'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['metatags' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($metatags),'schema' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($schema)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaac5c311a1def36561cfafc293b5015f)): ?>
<?php $attributes = $__attributesOriginalaac5c311a1def36561cfafc293b5015f; ?>
<?php unset($__attributesOriginalaac5c311a1def36561cfafc293b5015f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaac5c311a1def36561cfafc293b5015f)): ?>
<?php $component = $__componentOriginalaac5c311a1def36561cfafc293b5015f; ?>
<?php unset($__componentOriginalaac5c311a1def36561cfafc293b5015f); ?>
<?php endif; ?>
<?php else: ?>
    
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Language" content="<?php echo e(app()->getLocale()); ?>">
    <meta name="robots" content="index, follow">
    <meta name="description"
        content="<?php echo e(config('settings.site_description') ?? 'خدمات تطوير الويب والحلول الرقمية المتكاملة'); ?>">
    <meta name="author" content="<?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?>">
    <title><?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?></title>

    
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <meta http-equiv="Strict-Transport-Security" content="max-age=31536000; includeSubDomains; preload">

    
    <link rel="canonical" href="<?php echo e(url()->current()); ?>">

    
    <link rel="icon" href="<?php echo e(\App\Helper\Path::FavIcon()); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('favicon.png')); ?>" type="image/png">
    <link rel="apple-touch-icon" href="<?php echo e(asset('favicon.png')); ?>">

    
    <link rel="manifest" href="<?php echo e(route('manifest')); ?>?v=<?php echo e(time()); ?>">

    
    <meta name="theme-color" content="#007bff">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="<?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?>">
    <meta name="msapplication-TileColor" content="#007bff">
    <meta name="msapplication-tap-highlight" content="no">

    
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('favicon.png')); ?>">

    
    <meta name="msapplication-TileImage" content="<?php echo e(asset('favicon.png')); ?>">
    <meta name="msapplication-config" content="<?php echo e(asset('browserconfig.xml')); ?>">

    
    <meta property="og:title" content="<?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?>">
    <meta property="og:description"
        content="<?php echo e(config('settings.site_description') ?? 'خدمات تطوير الويب والحلول الرقمية المتكاملة'); ?>">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:image" content="<?php echo e(asset('assets/website/images/og-image.jpg')); ?>">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="<?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?>">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="<?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?>">
    <meta property="og:locale" content="<?php echo e(app()->getLocale()); ?>">
    <meta property="og:locale:alternate" content="<?php echo e(app()->getLocale() == 'en' ? 'ar' : 'en'); ?>">

    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?>">
    <meta name="twitter:description"
        content="<?php echo e(config('settings.site_description') ?? 'خدمات تطوير الويب والحلول الرقمية المتكاملة'); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('assets/website/images/og-image.jpg')); ?>">
    <meta name="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta name="twitter:site" content="@mibicom">
    <meta name="twitter:creator" content="@mibicom">

    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="dns-prefetch" href="//www.google-analytics.com">
    <link rel="dns-prefetch" href="//www.googletagmanager.com">

    
    <?php
        $locales = ['ar', 'en'];
        $currentPath = request()->path();
        $pathWithoutLocale = preg_replace('/^(ar|en)\/?/', '', $currentPath);

        // Check if this is a blog page
        if (preg_match('/^blogs\/(.+)$/', $pathWithoutLocale, $matches)) {
            $currentSlug = urldecode($matches[1]);

            // Try multiple methods to find the blog
            $blog = \App\Models\Blog::whereRaw("JSON_EXTRACT(slug, '$.ar') = ?", [$currentSlug])
                ->orWhereRaw("JSON_EXTRACT(slug, '$.en') = ?", [$currentSlug])
                ->first();

            // If not found with JSON_EXTRACT, try manual search
            if (!$blog) {
                $blogs = \App\Models\Blog::all();
                foreach ($blogs as $b) {
                    foreach (['ar', 'en'] as $lang) {
                        $blogSlug = $b->getTranslation('slug', $lang);
                        if ($blogSlug === $currentSlug) {
                            $blog = $b;
                            break 2;
                        }
                    }
                }
            }

            if ($blog) {
                foreach ($locales as $locale) {
                    $localizedUrl = $blog->getLocalizedUrl($locale);
                    if ($localizedUrl) {
                        echo '<link rel="alternate" hreflang="' . $locale . '" href="' . $localizedUrl . '" />';
                    }
                }
                // Add x-default pointing to Arabic (default language)
                $defaultUrl = $blog->getLocalizedUrl('ar');
                if ($defaultUrl) {
                    echo '<link rel="alternate" hreflang="x-default" href="' . $defaultUrl . '" />';
                }
            } else {
                // Fallback to simple method if blog not found
                $path = $pathWithoutLocale ? '/' . $pathWithoutLocale : '';
                foreach ($locales as $locale) {
                    echo '<link rel="alternate" hreflang="' .
                        $locale .
                        '" href="' .
                        url('/' . $locale . $path) .
                        '" />';
                }
                // Add x-default pointing to Arabic
                echo '<link rel="alternate" hreflang="x-default" href="' . url('/ar' . $path) . '" />';
            }
        } else {
            // For non-blog pages, use the simple method
            $path = $pathWithoutLocale ? '/' . $pathWithoutLocale : '';
            foreach ($locales as $locale) {
                echo '<link rel="alternate" hreflang="' . $locale . '" href="' . url('/' . $locale . $path) . '" />';
            }
            // Add x-default pointing to Arabic
            echo '<link rel="alternate" hreflang="x-default" href="' . url('/ar' . $path) . '" />';
        }
    ?>

    
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Organization",
        "name": "<?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?>",
        "url": "<?php echo e(url('/')); ?>",
        "logo": "<?php echo e(asset('assets/website/images/logo.png')); ?>",
        "description": "<?php echo e(config('settings.site_description') ?? 'خدمات تطوير الويب والحلول الرقمية المتكاملة'); ?>",
        "sameAs": [
            "https://www.facebook.com/mibicom",
            "https://x.com/mibicom",
            "https://www.linkedin.com/company/mibicom",
            "https://www.instagram.com/mibicom",
            "https://www.youtube.com/@mibicom"
        ]
    }
    </script>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebSite",
        "name": "<?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?>",
        "url": "<?php echo e(url('/')); ?>",
        "potentialAction": {
            "@type": "SearchAction",
            "target": "<?php echo e(url('/')); ?>?q={search_term_string}",
            "query-input": "required name=search_term_string"
        }
    }
    </script>
<?php endif; ?>



<!-- ======== CSS & Google Fonts ============ -->
<!-- Google Fonts -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&display=swap" rel="stylesheet">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<?php
    $currentLocale = app()->getLocale();
    $isRTL = in_array($currentLocale, ['ar', 'he', 'fa', 'ur']); // RTL languages
    $textDirection = $isRTL ? 'rtl' : 'ltr';
?>


<script>
    document.documentElement.setAttribute('lang', '<?php echo e($currentLocale); ?>');
    document.documentElement.setAttribute('dir', '<?php echo e($textDirection); ?>');
</script>

<?php if($isRTL): ?>
    
    <link href="<?php echo e(Path::css('rtl.css')); ?>" rel="stylesheet">
<?php else: ?>
    
    <link href="<?php echo e(Path::css('style.css')); ?>" rel="stylesheet">
<?php endif; ?>

<link href="<?php echo e(Path::css('responsive.css')); ?>" rel="stylesheet">
<link href="<?php echo e(Path::css('pagination.css')); ?>" rel="stylesheet">
<!-- ======== CSS & Google Fonts ============ -->
<?php /**PATH /home/webtest3/public_html/dhi/resources/views/components/website/partials/_head.blade.php ENDPATH**/ ?>