<!-- Mobile Menu  -->
<div class="mobile-menu">
    <div class="menu-backdrop"></div>
    <div class="close-btn"><i class="fas fa-times"></i></div>

    <nav class="menu-box">
        <div class="nav-logo">
            <a href="{{ Path::AppUrl('/') }}">
                <img src="{{ Path::AppLogo('site_logo') }}" class="logo_main" alt="logo" width="25" height="25"
                    loading="lazy">
            </a>
        </div>
        <div class="menu-outer">
        </div>
        <div class="contact-info">
            <h4>{{ __('website.contact_us') }}</h4>
            <ul>
                @if (isset($site_addresses) && is_iterable($site_addresses))
                    @foreach ($site_addresses as $address)
                        <li><a href="{{ $address->map_link ?? '#' }}" target="_blank">{{ $address->address ?? '' }}</a>
                        </li>
                    @endforeach
                @endif
                @if (isset($phones) && is_iterable($phones))
                    @foreach ($phones as $phone)
                        <li><a href="tel:{{ $phone->code ?? '' }}{{ $phone->phone ?? '' }}"
                                aria-label="Mobile Number">{{ $phone->phone ?? '' }}</a></li>
                    @endforeach
                @endif
                @if (isset($site_addresses) && is_object($site_addresses) && isset($site_addresses->email))
                    <li><a href="mailto:{{ $site_addresses->email }}"
                            aria-label="Contact Mail">{{ $site_addresses->email }}</a></li>
                @endif
            </ul>
        </div>
        <div class="social-links">
            <ul class="clearfix">
                @foreach ($socialMediaLinks as $platform => $link)
                    @if ($link && $link != '#')
                        <li><a href="{{ $link }}" target="_blank"><i
                                    class="fab fa-{{ $platform }}"></i></a></li>
                    @endif
                @endforeach

            </ul>
        </div>
    </nav>

</div>
<!-- End Mobile Menu -->
