@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<form class="default-form" action="{{ Path::AppUrl('save-contact-us') }}" method="post">
    @csrf
    <div class="row clearfix">
        <div class="col-lg-6 col-md-6 col-sm-12 form-group">
            <input type="text" name="name" placeholder="{{ __('website.name') }}" required>
        </div>
        <div class="col-lg-6 col-md-12 col-sm-12 form-group">
            <input type="text" name="email" placeholder="{{ __('website.email') }}" required>
        </div>
        <div class="col-lg-12 col-md-12 col-sm-12 form-group">
            <input type="text" name="phone" placeholder="{{ __('website.phone') }}" required>
        </div>
        <div class="col-lg-12 col-md-12 col-sm-12 form-group">
            <textarea name="message" id="" cols="60" rows="5" placeholder="{{ __('website.message') }}"
                required=""></textarea>
        </div>
        {{-- هذا الحقل هو ما سترسله للـ backend --}}
        <input type="hidden" name="recaptcha_token" id="recaptcha_token">
        <div class="col-lg-12 col-md-12 col-sm-12 form-group message-btn mr-0">
            <button class="theme-btn btn-one" type="submit" title="submit-form"
                name="submit-form"><span>{{ __('website.send') }}</span></button>
        </div>
    </div>
</form>
<!-- <======================= EndContactForm =========================> -->
@if (config('captcha.sitekey') && config('captcha.sitekey') !== 'Key')
    <script src="https://www.google.com/recaptcha/api.js?render={{ config('captcha.sitekey') }}"></script>

    <script>
        grecaptcha.ready(function() {
            grecaptcha.execute('{{ config('captcha.sitekey') }}', {
                action: 'contact'
            }).then(function(token) {
                document.getElementById('recaptcha_token').value = token;
            }).catch(function(error) {
                console.warn('reCAPTCHA error:', error);
            });
        });
    </script>
@else
    <script>
        console.warn('reCAPTCHA is not configured properly. Please set NOCAPTCHA_SITEKEY in your .env file');
    </script>
@endif
