<!--====================Site Footer==============-->
<footer class="main-footer">
    <div class="container">
        <div class="footer-top">
            <div class="top-inner">
                <div class="text">
                    <h5>{{ __('website.email') }}</h5>
                    <h3><a href="mailto:{{ config('settings.site_email') }}">{{ config('settings.site_email') }}</a></h3>
                </div>
                <figure class="footer-logo">
                    <a href="{{ Path::AppUrl('/') }}">
                        <img src="{{ Path::FooterLogo() }}" class="logo_main" alt="logo" width="150"
                            height="75">
                    </a>
                </figure>
                <div class="text">
                    <h5>{{ __('website.call_us') }}</h5>
                    @foreach ($phones as $phone)
                        @if ($phone->type == 'phone')
                            <h3><a href="tel:{{ $phone->code }}{{ $phone->phone }}" target="_blank" aria-label="mobile number"><i
                                        class="far fa-phone">{{ $phone->code }}{{ $phone->phone }}</i></a></h3>
                        @elseif($phone->type == 'whatsapp')
                            <h3><a href="https://wa.me/{{ $phone->code }}{{ $phone->phone }}" target="_blank" aria-label="whatsapp number"><i
                                        class="fab fa-whatsapp">{{ $phone->code }}{{ $phone->phone }}</i></a></h3>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
        <div class="widget-section">
            <div class="row clearfix">
                <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                    <div class="footer-widget links-widget">
                        <div class="widget-title">
                            <h4>{{ __('website.working_hours') }}</h4>
                        </div>
                        <div class="widget-content">
                            <p>
                                <span><i class="fa fa-clock"></i> {{ __('website.working_hours') }}:</span>
                                من السبت إلى الأربعاء من الساعة 3 عصراً حتى الساعة 8 مساءً
                            </p>
                            <p>
                                <span><i class="fa fa-clock"></i> {{ __('website.working_hours') }}:</span>
                                الخميس - الجمعة مغلق
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                    <div class="footer-widget contact-widget">
                        <div class="widget-title">
                            <h4>{{ __('website.our_location') }}</h4>
                        </div>
                        <div class="widget-content">
                            @foreach ($site_addresses as $address)
                                <p><a href="{{ $address->map_link }}" target="_blank">{{ $address->title }}: {{ $address->address }}</a></p>
                            @endforeach

                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                    <div class="footer-widget contact-widget">
                        <div class="widget-title">
                            <h4>{{ __('website.social_media') }}</h4>
                        </div>
                        <div class="widget-content">
                            <ul class="social-links clearfix">
                                <li><a href="{{ $socialMediaLinks['twitter'] }}" target="_blank" aria-label="Twitter Link"><i
                                            class="fab fa-twitter"></i></a></li>
                                <li><a href="{{ $socialMediaLinks['facebook'] }}" target="_blank"
                                        aria-label="Facebook Link"><i class="fab fa-facebook"></i></a></li>
                                <li><a href="{{ $socialMediaLinks['instagram'] }}" target="_blank"
                                        aria-label="Instagram Link"><i class="fab fa-instagram"></i></a></li>
                                <li><a href="{{ $socialMediaLinks['youtube'] }}" target="_blank"
                                        aria-label="Youtube Link"><i class="fab fa-youtube"></i></a></li>
                                <li><a href="{{ $socialMediaLinks['tiktok'] }}" target="_blank"
                                        aria-label="Tik tok Link"><img loading="lazy"
                                            src="{{ Path::FrontImage('tik-tok.png') }}" alt="tiktok image"
                                            width="15" height="15" /></a></li>
                                <li><a href="{{ $socialMediaLinks['snapchat'] }}" target="_blank"
                                        aria-label="Snapchat Link"><i class="fab fa-snapchat"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom centred">
        <div class="container">
            <div class="copyright">
                <p>All Rights Reserved DHI Egypt, Developed and Designed by <a href="https://be-group.com"
                        target="_blank">Be Group</a></p>
            </div>
        </div>
    </div>
</footer>
<!-- main-footer end -->

<!-- scroll to top -->
<button class="scroll-top scroll-to-target" data-target="html" aria-label="scroll to top">
    <i class="fas fa-arrow-up"></i>
</button>
<!--====================Footer==============-->
