@if (!empty($metatags))
    {{-- Basic Meta Tags --}}
    <meta charset="{{ $metatags['charset'] ?? 'utf-8' }}">
    <meta name="viewport" content="{{ $metatags['viewport'] ?? 'width=device-width, initial-scale=1.0' }}">
    <meta http-equiv="Content-Language" content="{{ $metatags['language'] ?? 'en' }}">
    <meta name="robots" content="{{ $metatags['robots'] ?? 'index, follow' }}">
    <meta name="description" content="{{ $metatags['description'] ?? '' }}">
    @if (!empty($metatags['keywords']))
        <meta name="keywords" content="{{ $metatags['keywords'] }}">
    @endif
    <meta name="author" content="{{ $metatags['author'] ?? '' }}">
    <title>{{ $metatags['title'] ?? config('settings.site_name') }}</title>

    @if (!empty($metatags['time']))
        <meta name="time" content="{{ $metatags['time'] }}">
    @endif

    {{-- Security Headers --}}
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <meta http-equiv="Strict-Transport-Security" content="max-age=31536000; includeSubDomains; preload">

    {{-- Canonical --}}
    @if (!empty($metatags['canonical']))
        <link rel="canonical" href="{{ $metatags['canonical'] }}">
    @else
        {{-- Generate clean canonical URL without language prefix conflicts --}}
        @php
            $currentUrl = url()->current();
            $canonicalUrl = $currentUrl;

            // Remove language prefix if it exists and we're on a localized route
if (app()->getLocale() !== config('app.fallback_locale')) {
    $localePrefix = '/' . app()->getLocale();
    if (str_starts_with($currentUrl, $localePrefix)) {
        $canonicalUrl = str_replace($localePrefix, '', $currentUrl);
    }
}

// Ensure we have a clean base URL
$canonicalUrl = rtrim($canonicalUrl, '/');
if (empty($canonicalUrl)) {
    $canonicalUrl = url('/');
            }
        @endphp
        <link rel="canonical" href="{{ $canonicalUrl }}">
    @endif

    {{-- Favicon --}}
    <link rel="icon" href="{{ \App\Helper\Path::FavIcon() }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('favicon.png') }}" type="image/png">
    <link rel="apple-touch-icon" href="{{ asset('favicon.png') }}">

    {{-- PWA Manifest --}}
    <link rel="manifest" href="{{ url(app()->getLocale() . '/manifest.json') }}">

    {{-- PWA Meta Tags --}}
    <meta name="theme-color" content="#007bff">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="{{ $metatags['title'] ?? config('settings.site_name') }}">
    <meta name="msapplication-TileColor" content="#007bff">
    <meta name="msapplication-tap-highlight" content="no">

    {{-- Apple Touch Icons --}}
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="152x152" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="144x144" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="120x120" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="114x114" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="76x76" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="72x72" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="60x60" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="57x57" href="{{ asset('favicon.png') }}">

    {{-- Microsoft Tiles --}}
    <meta name="msapplication-TileImage" content="{{ asset('favicon.png') }}">
    <meta name="msapplication-config" content="{{ asset('browserconfig.xml') }}">

    {{-- Open Graph --}}
    <meta property="og:title" content="{{ $metatags['og_title'] ?? ($metatags['title'] ?? '') }}">
    <meta property="og:description" content="{{ $metatags['og_description'] ?? ($metatags['description'] ?? '') }}">
    @php
        // Use the same canonical URL logic for Open Graph
        $currentUrl = url()->current();
        $ogUrl = $currentUrl;

        // Remove language prefix if it exists
        if (app()->getLocale() !== config('app.fallback_locale')) {
            $localePrefix = '/' . app()->getLocale();
            if (str_starts_with($currentUrl, $localePrefix)) {
                $ogUrl = str_replace($localePrefix, '', $currentUrl);
            }
        }

        $ogUrl = rtrim($ogUrl, '/');
        if (empty($ogUrl)) {
            $ogUrl = url('/');
        }
    @endphp
    <meta property="og:url" content="{{ $metatags['og_url'] ?? $ogUrl }}">
    <meta property="og:image" content="{{ $metatags['og_image'] ?? asset('images/default-og.jpg') }}">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="{{ $metatags['og_title'] ?? ($metatags['title'] ?? '') }}">
    <meta property="og:type" content="{{ $metatags['og_type'] ?? 'website' }}">
    <meta property="og:site_name" content="{{ $metatags['og_site_name'] ?? config('settings.site_name') }}">
    <meta property="og:locale" content="{{ $metatags['og_locale'] ?? app()->getLocale() }}">

    {{-- Twitter --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $metatags['twitter_title'] ?? ($metatags['title'] ?? '') }}">
    <meta name="twitter:description"
        content="{{ $metatags['twitter_description'] ?? ($metatags['description'] ?? '') }}">
    <meta name="twitter:image" content="{{ $metatags['twitter_image'] ?? asset('images/default-og.jpg') }}">
    <meta name="twitter:url" content="{{ $metatags['twitter_url'] ?? $ogUrl }}">
    @if (!empty($metatags['twitter_site']))
        <meta name="twitter:site" content="{{ $metatags['twitter_site'] }}">
    @endif
    @if (!empty($metatags['twitter_creator']))
        <meta name="twitter:creator" content="{{ $metatags['twitter_creator'] }}">
    @endif

    {{-- Performance --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="dns-prefetch" href="//www.google-analytics.com">
    <link rel="dns-prefetch" href="//www.googletagmanager.com">

    {{-- Hreflang Tags --}}
    @php
        $locales = ['ar', 'en'];
        $currentPath = request()->path();
        $pathWithoutLocale = preg_replace('/^(ar|en)\/?/', '', $currentPath);

        // Check if this is a blog page
        if (preg_match('/^blogs\/(.+)$/', $pathWithoutLocale, $matches)) {
            $currentSlug = urldecode($matches[1]);

            // Try multiple methods to find the blog
            $blog = \App\Models\Blog::whereRaw("JSON_EXTRACT(slug, '$.ar') = ?", [$currentSlug])
                ->orWhereRaw("JSON_EXTRACT(slug, '$.en') = ?", [$currentSlug])
                ->first();

            // If not found with JSON_EXTRACT, try manual search
            if (!$blog) {
                $blogs = \App\Models\Blog::all();
                foreach ($blogs as $b) {
                    foreach (['ar', 'en'] as $lang) {
                        $blogSlug = $b->getTranslation('slug', $lang);
                        if ($blogSlug === $currentSlug) {
                            $blog = $b;
                            break 2;
                        }
                    }
                }
            }

            if ($blog) {
                foreach ($locales as $locale) {
                    $localizedUrl = $blog->getLocalizedUrl($locale);
                    if ($localizedUrl) {
                        echo '<link rel="alternate" hreflang="' . $locale . '" href="' . $localizedUrl . '" />';
                    }
                }
                // Add x-default pointing to Arabic (default language)
                $defaultUrl = $blog->getLocalizedUrl('ar');
                if ($defaultUrl) {
                    echo '<link rel="alternate" hreflang="x-default" href="' . $defaultUrl . '" />';
                }
            } else {
                // Fallback to simple method if blog not found
                $path = $pathWithoutLocale ? '/' . $pathWithoutLocale : '';
                foreach ($locales as $locale) {
                    echo '<link rel="alternate" hreflang="' .
                        $locale .
                        '" href="' .
                        url('/' . $locale . $path) .
                        '" />';
                }
                // Add x-default pointing to Arabic
                echo '<link rel="alternate" hreflang="x-default" href="' . url('/ar' . $path) . '" />';
            }
        } else {
            // For non-blog pages, use the simple method
            $path = $pathWithoutLocale ? '/' . $pathWithoutLocale : '';
            foreach ($locales as $locale) {
                echo '<link rel="alternate" hreflang="' . $locale . '" href="' . url('/' . $locale . $path) . '" />';
            }
            // Add x-default pointing to Arabic
            echo '<link rel="alternate" hreflang="x-default" href="' . url('/ar' . $path) . '" />';
        }
    @endphp

    {{-- Google Tag Manager --}}
    @if (config('settings.google_tag_manager_id'))
        <script>
            (function(w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({
                    'gtm.start': new Date().getTime(),
                    event: 'gtm.js'
                });
                var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s),
                    dl = l != 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src =
                    'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '{{ config('settings.google_tag_manager_id') }}');
        </script>
    @endif

    {{-- Google Analytics --}}
    @if (config('settings.google_analytics_id'))
        <script async src="https://www.googletagmanager.com/gtag/js?id={{ config('settings.google_analytics_id') }}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', '{{ config('settings.google_analytics_id') }}');
        </script>
    @endif

@endif

{{-- Schema JSON-LD --}}
@if (!empty($schema))
    <script type="application/ld+json">
{!! json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@else
    {{-- Default WebPage Schema (safe encoding) --}}
    @php
        // Use the same canonical URL logic for schema
        $currentUrl = url()->current();
        $schemaUrl = $currentUrl;

        // Remove language prefix if it exists
        if (app()->getLocale() !== config('app.fallback_locale')) {
            $localePrefix = '/' . app()->getLocale();
            if (str_starts_with($currentUrl, $localePrefix)) {
                $schemaUrl = str_replace($localePrefix, '', $currentUrl);
            }
        }

        $schemaUrl = rtrim($schemaUrl, '/');
        if (empty($schemaUrl)) {
            $schemaUrl = url('/');
        }
    @endphp
    <script type="application/ld+json">
{!! json_encode([
        '@context' => 'https://schema.org',
        '@type' => 'WebPage',
        'name' => $metatags['title'] ?? config('settings.site_name'),
        'url' => $metatags['canonical'] ?? $schemaUrl,
        'description' => $metatags['description'] ?? ''
    ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif

{{-- FAQ Schema --}}
@if (!empty($faq_schema))
    <script type="application/ld+json">
    {!! json_encode($faq_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif

{{-- Breadcrumb Schema --}}
@if (!empty($breadcrumb_schema))
    <script type="application/ld+json">
    {!! json_encode($breadcrumb_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif

{{-- Google Tag Manager --}}
@if (config('settings.google_tag_manager_id'))
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', '{{ config('settings.google_tag_manager_id') }}');
    </script>
@endif

{{-- Google Analytics --}}
@if (config('settings.google_analytics_id'))
    <script async src="https://www.googletagmanager.com/gtag/js?id={{ config('settings.google_analytics_id') }}"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config', '{{ config('settings.google_analytics_id') }}');
    </script>
@endif

{{-- Default Schema for Organization and Website --}}
@if (empty($schema))
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Organization",
        "name": "{{ config('settings.site_name') ?? 'ميبيكوم' }}",
        "url": "{{ url('/') }}",
        "logo": "{{ asset('assets/website/images/logo.png') }}",
        "description": "{{ config('settings.site_description') ?? 'خدمات تطوير الويب والحلول الرقمية المتكاملة' }}",
        "sameAs": [
            "https://www.facebook.com/mibicom",
            "https://x.com/mibicom",
            "https://www.linkedin.com/company/mibicom",
            "https://www.instagram.com/mibicom",
            "https://www.youtube.com/@mibicom"
        ]
    }
    </script>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebSite",
        "name": "{{ config('settings.site_name') ?? 'ميبيكوم' }}",
        "url": "{{ url('/') }}",
        "potentialAction": {
            "@type": "SearchAction",
            "target": "{{ url('/') }}?q={search_term_string}",
            "query-input": "required name=search_term_string"
        }
    }
    </script>
@endif



<!-- ======== Service Worker ============ -->
<script>
    if ('serviceWorker' in navigator) {
        // Register service worker immediately, don't wait for load
        (async function() {
            try {
                const registration = await navigator.serviceWorker.register('{{ asset('sw.js') }}');
                console.log('✅ SW: Registered successfully with scope:', registration.scope);

                // Handle updates
                registration.addEventListener('updatefound', () => {
                    const newWorker = registration.installing;
                    console.log('🔄 SW: New version installing...');

                    newWorker.addEventListener('statechange', () => {
                        if (newWorker.state === 'installed') {
                            if (navigator.serviceWorker.controller) {
                                console.log(
                                    '🔄 SW: New version available, will activate on next load'
                                );
                            } else {
                                console.log('✅ SW: First time installation complete');
                            }
                        }
                    });
                });

                // Wait for service worker to be ready
                await navigator.serviceWorker.ready;
                console.log('🎉 SW: Ready and active');

                // Force claim all clients
                if (registration.active) {
                    registration.active.postMessage({
                        type: 'CLAIM_CLIENTS'
                    });
                }

            } catch (error) {
                console.error('❌ SW: Registration failed:', error);
            }
        })();

        // Handle online/offline status
        window.addEventListener('offline', () => {
            console.log('📱 App is now offline');
            document.body.classList.add('offline');

            // Test service worker response when offline
            fetch('/test-offline-navigation').catch(() => {
                console.log('🧪 SW: Offline navigation test - should show offline page');
            });
        });

        window.addEventListener('online', () => {
            console.log('🌐 App is back online');
            document.body.classList.remove('offline');

            // Refresh service worker cache when back online
            if (navigator.serviceWorker.controller) {
                navigator.serviceWorker.controller.postMessage({
                    type: 'REFRESH_CACHE',
                    url: window.location.href
                });
            }

            // Force manifest update
            setTimeout(() => {
                if (navigator.serviceWorker.controller) {
                    navigator.serviceWorker.controller.postMessage({
                        type: 'UPDATE_MANIFEST'
                    });
                }
            }, 1000);
        });
    } else {
        console.warn('⚠️ Service Worker not supported');
    }
</script>

<!-- Offline indicator styles -->
<style>
    .offline::before {
        content: '📱 غير متصل';
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        background: #dc3545;
        color: white;
        text-align: center;
        padding: 8px;
        font-size: 14px;
        z-index: 9999;
    }
</style>
{{-- Lazy Loading Images --}}
<script>
    // Lazy loading for images
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('img').forEach(function(img) {
            img.setAttribute('loading', 'lazy');
        });
    });

    // Force manifest refresh
    function forceManifestUpdate() {
        const manifestLink = document.querySelector('link[rel="manifest"]');
        if (manifestLink) {
            const currentHref = manifestLink.href;
            const separator = currentHref.includes('?') ? '&' : '?';
            manifestLink.href = currentHref.split('?')[0] + separator + 'v=' + Date.now();
            console.log('🔄 Manifest updated:', manifestLink.href);
        }
    }

    // Update manifest on page load
    window.addEventListener('load', () => {
        setTimeout(forceManifestUpdate, 500);
    });
</script>

{{-- Web Vitals --}}
<script src="https://unpkg.com/web-vitals@3/dist/web-vitals.iife.js" crossorigin type="text/javascript"></script>
<script>
    window.addEventListener('load', function() {
        if (typeof webVitals !== 'undefined') {
            try {
                // CLS - Cumulative Layout Shift
                webVitals.getCLS(function(metric) {
                    console.log('CLS:', metric);
                    if (typeof gtag !== 'undefined') {
                        gtag('event', 'web_vitals', {
                            'event_category': 'Performance',
                            'event_label': 'CLS',
                            'value': Math.round(metric.value * 1000),
                            'custom_parameter_1': metric.rating,
                            'custom_parameter_2': window.location.pathname
                        });
                    }

                    fetch('/dashboard/performance/store', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                ?.getAttribute('content') || ''
                        },
                        body: JSON.stringify({
                            metric: 'CLS',
                            value: metric.value,
                            rating: metric.rating,
                            page: window.location.pathname
                        })
                    }).catch(error => console.log('Performance data not sent:', error));
                });

                // FID - First Input Delay
                webVitals.getFID(function(metric) {
                    console.log('FID:', metric);
                    if (typeof gtag !== 'undefined') {
                        gtag('event', 'web_vitals', {
                            'event_category': 'Performance',
                            'event_label': 'FID',
                            'value': Math.round(metric.value)
                        });
                    }
                });

                // LCP - Largest Contentful Paint
                webVitals.getLCP(function(metric) {
                    console.log('LCP:', metric);
                    if (typeof gtag !== 'undefined') {
                        gtag('event', 'web_vitals', {
                            'event_category': 'Performance',
                            'event_label': 'LCP',
                            'value': Math.round(metric.value)
                        });
                    }
                });

                // FCP - First Contentful Paint
                webVitals.getFCP(function(metric) {
                    console.log('FCP:', metric);
                    if (typeof gtag !== 'undefined') {
                        gtag('event', 'web_vitals', {
                            'event_category': 'Performance',
                            'event_label': 'FCP',
                            'value': Math.round(metric.value)
                        });
                    }
                });

                // TTFB - Time to First Byte
                webVitals.getTTFB(function(metric) {
                    console.log('TTFB:', metric);
                    if (typeof gtag !== 'undefined') {
                        gtag('event', 'web_vitals', {
                            'event_category': 'Performance',
                            'event_label': 'TTFB',
                            'value': Math.round(metric.value)
                        });
                    }
                });
            } catch (error) {
                console.warn('Web Vitals error:', error);
            }
        } else {
            console.warn('Web Vitals library not loaded');
        }
    });
</script>
