<!-- <================================================================= StartContactForm =======================================================> -->
{{-- <section class="contact pt-5">
  <div class="container py-5">
    @if (request()->segment(2) != 'contact-us')
    <div class="header-text mb-5">
      <h2 class="fw-bold fs-1 text-center">{{__('website.contact_us')}}</h2>
    </div>
    @endif
    <div class="row justify-content-center mb-5">
      <div class="col-12">
        <div class="row g-4">
          <div class="col-md-4">
            <div
              class="bg-light rounded-4 shadow-sm text-center py-4 px-2 h-100 d-flex flex-column align-items-center justify-content-center">
              <div class="mb-3 d-flex align-items-center justify-content-center">
                <i class="fa-solid fa-phone fs-2" style="color: #14489f"></i>
              </div>
              <div class="fw-semibold text-muted mb-1">{{__('website.contact_us')}}</div>
              @foreach ($phones as $phone)
              <div class="fs-5 fw-bold" style="color: #14489f">
                <a href="tel:{{ $phone->code }}{{$phone->phone}}">{{$phone->phone}}</a>
              </div>
              @endforeach
            </div>
          </div>
          <div class="col-md-4">
            <div
              class="bg-light rounded-4 shadow-sm text-center py-4 px-2 h-100 d-flex flex-column align-items-center justify-content-center">
              <div class="mb-3 d-flex align-items-center justify-content-center">
                <i class="fa-solid fa-envelope fs-2" style="color: #14489f"></i>
              </div>
              <div class="fw-semibold text-muted mb-1">{{__('website.email')}}</div>
              <div class="fs-5 fw-bold" style="color: #14489f">
                <a href="mailto:{{config('settings.site_email')}}">{{config('settings.site_email')}}</a>
              </div>
            </div>
          </div>
          <div class="col-md-4">
            <div
              class="bg-light rounded-4 shadow-sm text-center py-4 px-2 h-100 d-flex flex-column align-items-center justify-content-center">
              <div class="mb-3 d-flex align-items-center justify-content-center">
                <i class="fa-solid fa-location-dot fs-2" style="color: #14489f"></i>
              </div>
              <div class="fw-semibold text-muted mb-1">
                {{__('website.address')}}
              </div>
              @foreach ($site_addresses as $address)
              <div class="fs-5 fw-bold" style="color: #14489f">
                <a href="{{$address->map_link}}" target="_blank">{{$address->address}}</a>
              </div>
              @endforeach
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row g-4">
      @foreach ($site_addresses as $index => $address)
      @if ($index == 0)
      <div class="col-lg-5 mb-lg-0">
        <div class="h-100 d-flex flex-column justify-content-stretch">
          <iframe
            src="{{$address->map_url}}"
            width="100%" height="100%" style="
                  border: 0;
                  min-height: 100%;
                  height: 100%;
                  display: block;
                " class="rounded-4 overflow-hidden shadow-lg h-100 w-100" allowfullscreen="" loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
      </div>
      @endif
      @endforeach

      <div class="col-lg-7">
        <div class="rounded-4 shadow-lg p-4 p-md-5 h-100 d-flex flex-column justify-content-center">
          <x-website.partials.contact-form />
        </div>
      </div>
    </div>
  </div>
</section> --}}
<section class="contact-section">
    <div class="container">
        <div class="row clearfix">
            <div class="col-lg-5 col-md-12 col-sm-12 content-column">
                <div class="content_block_six">
                    <div class="content-box">
                        @foreach ($sections as $section)
                            @if ($section->key == 'contact')
                                <div class="sec-title">
                                    <span class="sub-title">{{ $section->name }}</span>
                                    <h2>{{ $section->title }}</h2>
                                </div>
                            @endif
                        @endforeach
                        <div class="inner-box">
                            <div class="single-item">
                                <div class="icon-box"><i class="fa fa-envelope"></i></div>
                                <p>{{ __('website.email') }}</p>
                                <h3><a href="mailto:{{ config('settings.site_email') }}"
                                        aria-label="contact">{{ config('settings.site_email') }}</a></h3>
                            </div>
                            <div class="single-item">
                                <div class="icon-box"><i class="fa fa-phone"></i></div>
                                <p>{{ __('website.call_us') }}</p>
                                @foreach ($phones as $phone)
                                    @if ($phone->type == 'phone')
                                        <h3><a href="tel:{{ $phone->code }}{{ $phone->phone }}" aria-label="phone">
                                                <i class="fas fa-phone"></i> {{ $phone->code }}{{ $phone->phone }}
                                            </a></h3>
                                    @elseif($phone->type == 'whatsapp')
                                        <h3><a href="https://wa.me/{{ $phone->code }}{{ $phone->phone }}"
                                                aria-label="whatsapp" target="_blank">
                                                <i class="fab fa-whatsapp"></i> {{ $phone->code }}{{ $phone->phone }}
                                            </a></h3>
                                    @endif
                                @endforeach
                            </div>
                            @foreach ($site_addresses as $address)
                                <div class="single-item">
                                    <div class="icon-box"><i class="fa fa-map-marked-alt"></i></div>
                                    <p>{{ $address->title }}</p>

                                    <h3><a href="{{ $address->map_link }}" target="_blank"
                                            aria-label="map">{{ $address->address }}</a></h3>

                                </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-7 col-md-12 col-sm-12 form-column">
                <div class="form-inner">
                    <x-website.partials.contact-form />

                </div>
            </div>
        </div>
    </div>
</section>
<!-- <======================= EndContactForm =========================> -->
