<ul class="main-menu">
    @foreach ($menus as $menu)
        @php
            $hasChildren = $menu->relationLoaded('children')
                ? $menu->children->isNotEmpty()
                : $menu->children()->exists();
            $isServices = trim($menu->segment, '/') === 'services';
            $isProducts =trim($menu->segment, '/')==='products';
        @endphp
        <li class="{{ $hasChildren || $isServices ? 'has-dropdown' : '' }}">
            <a href="{{ $menu->segment === '#' ? '#' : $menu->link }}">{{ $menu->name }}</a>

            @if ($hasChildren)
                <ul class="submenu">
                    @foreach ($menu->children as $child)
                        <li><a href="{{ $child->link }}">{{ $child->name }}</a></li>
                    @endforeach
                </ul>
            @elseif ($isServices)
                <x-website.partials.services-submenu />
                @elseif($isProducts)
                <x-website.partials.products-submenu />
            @endif
        </li>
    @endforeach
</ul>
