<!--==========================Services==========================-->
<section class="product-section section-padding pt-100 z-2" style="background-image: url('https://www.g-homes.net/tulip-new/public/assets/website/img/whiteBg.png');">
    <div class="container">
        @foreach ($sections as $section)
            @if ($section->key == 'products')
                <div class="section-title text-center">
                    <h6 class="wow fadeInUp">{{ $section->title }}</h6>
                    <h2 class="wow fadeInUp" data-wow-delay=".3s">{{ $section->second_title }}</h2>
                </div>
            @endif
        @endforeach
        <div class="product-header mt-4 mt-md-0">
            <ul class="nav">
                @foreach ($categories as $index => $category)
                    <li class="nav-item wow fadeInUp" data-wow-delay=".2s">
                        <a href="#{{ $category->id }}" data-bs-toggle="tab" class="nav-link">
                            {{ $category->name }}
                        </a>
                    </li>
                @endforeach
            </ul>
        </div>
        <div class="tab-content">
            @foreach ($categories as $index => $category)
                <div id="{{ $category->id }}"
                    class="tab-pane fade @if ($index == 0) show active @endif">
                    <div class="row">
                        @foreach ($category->products as $product)
                            <div class="col-xl-3 col-lg-4 col-md-6 wow fadeInUp">
                                <div class="product-box-items">
                                    <div class="product-image">
                                        <img src="{{ $product->image_path }}" alt="{{ $product->name }}">

                                        <div class="shop-btn">
                                            <a href="{{ $product->link }}"
                                                class="theme-btn">{{ __('website.read_more') }}</a>
                                        </div>
                                    </div>
                                    <div class="product-content">
                                        <h6><a href="{{ $product->link }}">{{ $product->name }}</a></h6>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endforeach
        </div>
        <div class="shop-button text-center mt-5 wow fadeInUp" data-wow-delay=".4s">
            <a href="{{ Path::AppUrl('products') }}" class="theme-btn">{{ __('website.view_all_products') }}</a>
        </div>
    </div>
</section>
<!--==========================Services==========================-->
