<?php

namespace Database\Seeders;

use App\Models\SeoAssistant;
use Illuminate\Database\Seeder;

class SeoAssistantSeeder extends Seeder
{
    public function run(): void
    {
        SeoAssistant::updateOrCreate(
            ['id' => 1],
            [
                // Home Page
                'home_meta_title_en' => 'Site | Professional Web Development & Digital Solutions',
                'home_meta_desc_en' => 'Leading provider of web development, digital solutions, and IT services. We create custom websites, e-commerce platforms, and digital transformation solutions.',
                'home_meta_title_ar' => 'ميبيكوم | خدمات تطوير الويب والحلول الرقمية المتكاملة',
                'home_meta_desc_ar' => 'نقدم خدمات احترافية في تطوير المواقع والحلول الرقمية وتكنولوجيا المعلومات. تصميم مواقع مخصصة وحلول تجارة إلكترونية متكاملة.',

                // About Page
                'about_meta_title_en' => 'About Site | Our Digital Innovation Journey',
                'about_meta_desc_en' => 'Discover Site\'s journey in digital innovation. Our expert team delivers exceptional web development and IT solutions for businesses worldwide.',
                'about_meta_title_ar' => 'عن ميبيكوم | مسيرتنا في الابتكار الرقمي',
                'about_meta_desc_ar' => 'تعرف على قصة نجاح ميبيكوم في مجال الابتكار الرقمي. فريقنا المتخصص يقدم حلول تطوير ويب وتقنية معلومات استثنائية.',

                // Blog Page
                'blog_meta_title_en' => 'Site Blog | Latest Digital & Tech Insights',
                'blog_meta_desc_en' => 'Stay informed with the latest digital transformation trends and tech insights. Expert tips on web development and technology innovation.',
                'blog_meta_title_ar' => 'مدونة ميبيكوم | أحدث رؤى التقنية والتحول الرقمي',
                'blog_meta_desc_ar' => 'اكتشف أحدث اتجاهات التحول الرقمي ونصائح تطوير الويب. رؤى خبراء في التكنولوجيا والابتكار الرقمي.',

                // Services Page
                'service_meta_title_en' => 'Web & Digital Services | Site Solutions',
                'service_meta_desc_en' => 'Expert web development and digital transformation services. Custom solutions designed to enhance your business presence and efficiency.',
                'service_meta_title_ar' => 'خدمات الويب والحلول الرقمية | ميبيكوم',
                'service_meta_desc_ar' => 'خدمات احترافية في تطوير الويب والتحول الرقمي. حلول مخصصة لتعزيز حضور شركتك وكفاءتها في العالم الرقمي.',

                // Products Page
                'products_meta_title_en' => 'Digital Products & Solutions | Site Store',
                'products_meta_desc_en' => 'Explore our range of digital products and solutions. From e-commerce platforms to custom applications for business growth.',
                'products_meta_title_ar' => 'المنتجات والحلول الرقمية | متجر ميبيكوم',
                'products_meta_desc_ar' => 'اكتشف مجموعة منتجاتنا وحلولنا الرقمية. من منصات التجارة الإلكترونية إلى التطبيقات المخصصة لنمو الأعمال.',
            ]
        );
    }
}