<?php

namespace App\Services\Dashboard;

use App\Models\Album;
use Illuminate\Support\Facades\DB;
use App\Helper\Media;

class AlbumService
{
    public function store($request, $data)
    {
        DB::beginTransaction();
        try {
            if($request->hasFile('image')){
                $data['image']=Media::uploadAndAttachImage($request->file('image'),'albums');
            }
            $album = Album::create($data);
            DB::commit();
            return $album;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function update($request, $data, $album)
    {
         DB::beginTransaction();
        try {
        if($request->hasFile('image')){
            if($album->image){
                Media::removeFile('albums',$album->image);
            }
            $data['image']=Media::uploadAndAttachImage($request->file('image'),'albums');
        }
       
            $album->update($data);
            DB::commit();
            return $album;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function delete($selectedIds)
    {
        $albums = Album::whereIn('id', $selectedIds)->get();
        DB::beginTransaction();
        try {
            foreach ($albums as $album) {
                if ($album->image) {
                    Media::removeFile('albums', $album->image);
                }
                $album->delete();
            }
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }
}
