<?php

namespace App\Http\Requests\Dashboard\Authors;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAuthorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name_en' => 'required|string|max:255',
            'name_ar' => 'required|string|max:255',
            'email' => 'nullable|email|max:255|unique:authors,email,' . $this->author->id,
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'alt_image' => 'nullable|string|max:255',
            'status' => 'nullable|boolean',
            'role' => 'nullable|string|max:255',
        ];
    }
}
