<script>
    $(document).on('click', '.btn-add-to-sample-request', function() {
        var productId = $(this).data('product_id'); // Retrieve the product ID
        var $form = $('#variant-form');
        // Collect selected variants
        var selectedVariantValues = {};

        $form.find('input[type=radio]:checked').each(function() {
            var name = $(this).attr('name');
            var attributeId = name.match(/\[(\d+)\]/)[1];
            selectedVariantValues[attributeId] = $(this).val();
        });

        
        $.ajax({
            url: "<?php echo e(url('sample-request/add')); ?>" // Update the URL to add to sample request
            , method: 'POST'
            , data: {
                product_id: productId,
                selectedVariantValues: selectedVariantValues,
                _token: '<?php echo e(csrf_token()); ?>' // Include CSRF token for security

            }
            , success: function(data) {
                if (data.status) {
                    $(".count-sampleRequest").text(data.SampleRequestCount);
                    toastr.success(<?php echo json_encode(__('Item added to Sample request successfully'), 15, 512) ?>); // Updated message
                }
            }
            , error: function(xhr) {
                if (xhr.status == 401) {
                    window.location.href = "<?php echo e(url('login')); ?>";
                }
            }
        });
    });

</script>
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/scripts/sample-request/addToSampleRequest.blade.php ENDPATH**/ ?>