<title><?php echo e(trans('home.edit_attribute')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.attributes')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/attributes')); ?>"><?php echo e(trans('home.attributes')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_attribute')); ?></li>
            </ol>
        </div>
    </div>

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1"><?php echo e(trans('home.edit_attribute')); ?></h6>
                    </div>
                    <form action="<?php echo e(route('attributes.update',[$attribute->id])); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="border">


                            <div class="card-body tab-content">
                                <!-- Tab 1: Attribute Details -->
                                <div class="tab-pane active show" id="tab1">
                                    <div class="row">
                                        <div class="form-group col-md-6">
                                            <label><?php echo e(trans('home.name_en')); ?></label>
                                            <input class="form-control" name="name_en" type="text" value="<?php echo e($attribute->name_en); ?>" placeholder="<?php echo e(trans('home.name_en')); ?>" required>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label><?php echo e(trans('home.name_ar')); ?></label>
                                            <input class="form-control" name="name_ar" type="text" value="<?php echo e($attribute->name_ar); ?>" placeholder="<?php echo e(trans('home.name_ar')); ?>">
                                        </div>

                                        <div class="form-group col-md-12">
                                            <label class="ckbox">
                                                <input name="status" value="1" type="checkbox" <?php echo e($attribute->status ? 'checked' : ''); ?>><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <!-- Attribute Values Table-->

                                <?php echo $__env->make('admin.attribute-values.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <!-- End Attribute Values -->
                            </div>

                            <div class="form-group col-md-12 mt-3">
                                <button type="submit" class="btn btn-success"><?php echo e(trans('home.save')); ?></button>
                                <a href="<?php echo e(route('attributes.index')); ?>">
                                    <button type="button" class="btn btn-danger mr-1"><?php echo e(trans('home.cancel')); ?></button>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/attributes/edit.blade.php ENDPATH**/ ?>