<!-- Edit Modal for this Record -->
<div class="modal fade" id="editModal-<?php echo e($value->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModal-<?php echo e($value->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Edit Value')); ?> - <?php echo e($value->id); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" action="<?php echo e(route('attributes.values.update',[$attribute->id,$value->id])); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>

                    <div class="row">
                        <div class="form-group col-md-4">
                            <label><?php echo e(__('dashboard.value_en')); ?></label>
                            <input class="form-control" name="value_en" type="text" value="<?php echo e($value->value_en); ?>" placeholder="<?php echo e(__('dashboard.value_en')); ?>">
                        </div>

                        <div class="form-group col-md-4">
                            <label><?php echo e(__('dashboard.value_ar')); ?></label>
                            <input class="form-control" name="value_ar" type="text" value="<?php echo e($value->value_ar); ?>" placeholder="<?php echo e(__('dashboard.value_ar')); ?>">
                        </div>

                        <?php if($attribute->isColor()): ?>
                        <div class="form-group col-md-4">
                            <label><?php echo e(__('dashboard.code')); ?></label>
                            <input class="form-control" name="code" type="color" value="<?php echo e($value->code); ?>" placeholder="<?php echo e(__('dashboard.code')); ?>">
                        </div>
                        <?php endif; ?>

                        <div class="form-group col-md-6">
                            <div class="d-flex flex-wrap gap-2">
                                
                                <input type="checkbox" id="switch-<?php echo e($value->id); ?>" switch="none" name="status" value="1" <?php echo e($value->status ? 'checked' : ''); ?> />
                                <label for="switch-<?php echo e($value->id); ?>" data-on-label="<?php echo e(__('dashboard.yes')); ?>" data-off-label="<?php echo e(__('dashboard.no')); ?>" class="mb-0 mx-2"><?php echo e(__('dashboard.publish/unpublish')); ?></label>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Save changes')); ?></button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/attribute-values/edit.blade.php ENDPATH**/ ?>