<div class="card-product bg_white radius-0">
    <div class="card-product-wrapper">
        <a href="<?php echo e(route('product.details',$product->link)); ?>" class="product-img">
            <img class="lazyload img-product" data-src="<?php echo e($product->main_image_path); ?>" src="<?php echo e($product->main_image_path); ?>" alt="image-product">
            <img class="lazyload img-hover" data-src="<?php echo e($product->main_image_path); ?>" src="<?php echo e($product->main_image_path); ?>" alt="image-product">
        </a>
        <?php if($product->isInStock() == false): ?>
            <span class="alarm"><?php echo e(__('home.out of stock')); ?></span>
        <?php endif; ?>
        
        <div class="list-product-btn absolute-2">
            <button type="button" class="box-icon bg_white tf-btn-loading btn-add-to-cart " data-product_id="<?php echo e($product->id); ?>" <?php if($product->isInStock() == false): echo 'disabled'; endif; ?>
                title="<?php echo e($product->isInStock() == false ? 'Out of stock' : 'Add to cart'); ?>">
                <span class="icon icon-bag"></span>
                <span class="tooltip"><?php echo e($product->isInStock() == false ? 'Out of stock' : 'Add to cart'); ?></span>
            </button>
            <a href="javascript:void(0);" class="box-icon bg_white wishlist btn-icon-action">
                <span class="icon icon-heart add-wishList-item" data-product_id="<?php echo e($product->id); ?>"></span>
                <span class="tooltip"><?php echo e(__('home.add to wishlist')); ?></span>
                <span class="icon icon-delete remove-wishList-item" data-product_id="<?php echo e($product->id); ?>"></span>
            </a>
            
            
        </div>

    </div>
    <div class="card-product-info has-padding">
        <a href="<?php echo e(route('product.details',$product->link)); ?>" class="title link"><?php echo e($product->name); ?></a>
        <div class="tf-product-info-price">
            <div class="product-pricing">
                <?php if($product->isOnSale()): ?>
                <div class="sale-price">
                    <strong>Now:</strong> <?php echo e(config('app.currency')); ?> <?php echo e($product->getEffectivePrice()); ?>

                </div>
                <div class="original-price">
                    <strong>Before sale price:</strong>
                    <del><?php echo e(config('app.currency')); ?> <?php echo e($product->getOriginalPrice()); ?></del>
                </div>
                <div class="save-discount">
                    <strong>Save:</strong> <?php echo e(config('app.currency')); ?> <?php echo e($product->getDiscountAmount()); ?>

                </div>
                <?php else: ?>
                <span class="original-price"><?php echo e(config('app.currency')); ?> <?php echo e($product->getOriginalPrice()); ?></span>
                <?php endif; ?>
            </div>
        </div>

    </div>
</div>
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/home-partials/partials/_product-no-variants.blade.php ENDPATH**/ ?>