<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.discounts')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="spainer"></div>
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.discounts')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(url('/admin')); ?>"> <?php echo e(trans('home.admin')); ?></a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(url('admin/products')); ?>"><?php echo e(trans('home.products')); ?> </a>
                    </li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/products/' . $product->id.'/edit')); ?>"><?php echo e($product->name); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.discounts')); ?></li>
                </ol>
            </div>
        </div>
      <?php echo $__env->make('admin.products.discounts.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.products')); ?></h6>
                            <p class="text-muted card-sub-title">
                                <?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?>

                            </p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>

                                        <th>#</th>
                                        <th class="wd-20p"><?php echo e(trans('home.name')); ?></th>
                                        <th  class="wd-20p"><?php echo e(__('home.variant')); ?></th>
                                        <th class="wd-20p"><?php echo e(trans('home.type')); ?></th>
                                        <th class="wd-20p"><?php echo e(trans('home.value')); ?></th>
                                        <th class="wd-20p"><?php echo e(trans('home.starts_at')); ?></th>
                                        <th class="wd-25p"><?php echo e(trans('home.expires_at')); ?></th>
                                        <th class="wd-20p"><?php echo e(trans('home.status')); ?></th>
                                        <th class="wd-20p"><?php echo e(trans('home.edit')); ?></th>
                                        <th class="wd-20p"><?php echo e(trans('home.edit')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>


                                    <?php $__currentLoopData = $discounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $discount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr >
                                            <td> <?php echo e($key + 1); ?> </td>
                                            <td> <?php echo e($discount->name); ?>  </td>
                                            <td>
                                                <?php if($discount->variant): ?>
                                                <?php $__currentLoopData = $discount->variant->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variantValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="badge badge-primary"><?php echo e($variantValue->value->value); ?></span>
                                               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>

                                            </td>
                                            <td> <?php echo e($discount->type); ?>  </td>
                                            <td> <?php echo e($discount->value); ?>  </td>
                                            <td> <?php echo e($discount->starts_at); ?>  </td>
                                            <td> <?php echo e($discount->expires_at); ?>  </td>
                                            <td  class="<?php echo e($discount->is_active ? 'bg-success' : ''); ?>"> <?php echo e($discount->is_active  ? 'active' : 'Not Active'); ?> </td>
                                            <td>
                                                <a href="<?php echo e(route('products.discounts.edit', [$product->id, $discount->id])); ?>" class="btn btn-info">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </td>
                                            <td>
                                                <form action="<?php echo e(route('products.discounts.destroy', [$product->id, $discount->id])); ?>" method="POST"  class="delete-form">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger btn-delete-form">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/products/discounts/index.blade.php ENDPATH**/ ?>