<title><?php echo e(trans('home.products')); ?></title>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.products')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.products')); ?></li>
            </ol>
        </div>

        <div class="btn btn-list">
            <a href="<?php echo e(url('admin/products/create')); ?>"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
            <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> <?php echo e(trans('home.publish/unpublish')); ?></button></a>
            <a id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('home.delete')); ?></button></a>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1"><?php echo e(trans('home.products')); ?></h6>
                        <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                    </div>

                    <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll" /></th>
                                    <th>#</th>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.name_en')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.name_ar')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.image')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.category')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.brand')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.featured')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.variants')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.hot_offers')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.images')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.status')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($product->id); ?>">
                                    <td> <input type="checkbox" name="checkbox" class="tableChecked" value="<?php echo e($product->id); ?>" /> </td>
                                    <td><a href="<?php echo e(route('products.edit', $product->id)); ?>"><?php echo e($key+1); ?></a></td>
                                    <td><a href="<?php echo e(route('products.edit', $product->id)); ?>"><?php echo e($product->id); ?></a></td>
                                    <td><a href="<?php echo e(route('products.edit', $product->id)); ?>"><?php echo e($product->name_en); ?></a></td>
                                    <td><a href="<?php echo e(route('products.edit', $product->id)); ?>"><?php echo e($product->name_ar); ?></a></td>
                                    <td>
                                        <a href="<?php echo e(route('products.edit', $product->id)); ?>">
                                            <img style="border-radius:50%" src="<?php echo e($product->main_image_path); ?>" alt="product-image" title="<?php echo e($product->name); ?>" width="50" height="50">
                                        </a>
                                    </td>
                                    <td><a href="<?php echo e(route('products.edit', $product->id)); ?>"> <?php echo e($product->category_name ?? __('home.no category')); ?> </a></td>
                                    <td><a href="<?php echo e(route('products.edit', $product->id)); ?>"> <?php echo e($product->brand_name ?? __('home.no brand')); ?> </a></td>
                                    <td>

                                        <?php if($product->featured): ?>
                                        <span class="btn badge-success" style="min-width: 100%"><?php echo e(trans('home.yes')); ?></span>
                                        <?php else: ?>
                                        <span class="btn badge-light" style="min-width: 100%"><?php echo e(trans('home.no')); ?></span>
                                        <?php endif; ?>

                                    </td>
                                    <td>

                                        <?php if($product->variants->isNotEmpty()): ?>
                                        <span class="btn badge-success" style="min-width: 100%"><?php echo e(trans('home.yes')); ?></span>
                                        <?php else: ?>
                                        <span class="btn badge-light" style="min-width: 100%"><?php echo e(trans('home.no')); ?></span>
                                        <?php endif; ?>

                                    </td>
                                    <td>
                                        
                                        <?php if($product->discount): ?>
                                        <span class="btn badge-success" style="min-width: 100%"><?php echo e(trans('home.yes')); ?></span>
                                        <?php else: ?>
                                        <span class="btn badge-light" style="min-width: 100%"><?php echo e(trans('home.no')); ?></span>
                                        <?php endif; ?>
                                        
                                    </td>
                                    <td><a href="<?php echo e(route('products.images.index', $product->id)); ?>"><?php echo e(__('home.view')); ?> <br>(<?php echo e($product->images()->count()); ?> <?php echo e(__('home.image')); ?>) </a></td>
                                    <td>
                                        <a href="<?php echo e(route('products.edit', $product->id)); ?>" class="status">
                                            <?php if($product->status == 1): ?>
                                            <span class="btn badge-success" style="min-width: 100%"><?php echo e(trans('home.yes')); ?></span>
                                            <?php else: ?>
                                            <span class="btn badge-danger" style="min-width: 100%"><?php echo e(trans('home.no')); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>



            </div>
        </div>
    </div>
    <!-- End Row -->
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/products/index.blade.php ENDPATH**/ ?>