<?php
use App\Http\Controllers\Admin\SettingController;
use Illuminate\Support\Facades\Route;

Route::group(['controller' => \App\Http\Controllers\Admin\AdminController::class], function () {
    Route::get('/', 'index')->name('home');
    Route::get('switch-theme', 'switchTheme')->name('switchTheme');
    Route::get('translations', 'switchTheme')->name('translations');
    Route::post('{modelname}/change-status/{ids}', 'changeStatus')->name('change.status');
});


Route::patch('/settings/{setting}', [SettingController::class,'update'])->name('settings.update');
Route::get('/settings', [SettingController::class,'index'])->name('settings.index');

Route::group(['prefix' => 'configrations', 'controller' => \App\Http\Controllers\Admin\ConfigrationController::class, 'as' => 'configrations.'], function () {
    Route::get('{lang}', 'edit')->name('edit');
    Route::patch('{lang}', 'update')->name('update');
});

Route::group(['prefix' => 'about' , 'controller' => \App\Http\Controllers\Admin\AboutController::class, 'as' => 'about.'], function () {
    Route::get('edit', 'editAbout')->name('edit');
    Route::patch('update', 'update')->name('update');
});

Route::resources([
    'sliders' => App\Http\Controllers\Admin\SliderController::class,
    'menus' => App\Http\Controllers\Admin\MenuController::class,
    'categories' => App\Http\Controllers\Admin\CategoryController::class,
    'aboutStrucs' => App\Http\Controllers\Admin\AboutStrucController::class,
    'pages' => App\Http\Controllers\Admin\PageController::class,
    'payment-methods' => App\Http\Controllers\Admin\PaymentMethodController::class,
    'countries' => App\Http\Controllers\Admin\CountryController::class,
    'governorates' => App\Http\Controllers\Admin\GovernorateController::class,
    'roles' => App\Http\Controllers\Admin\RoleController::class,
    'permissions' => App\Http\Controllers\Admin\PermissionController::class,
    'site-addresses' => App\Http\Controllers\Admin\SiteAddressController::class,
    'attributes' => App\Http\Controllers\Admin\AttributeController::class,
    'attributes.values' => App\Http\Controllers\Admin\AttributeValueController::class,
    'partners' => App\Http\Controllers\Admin\PartnerController::class,
    'branches' => App\Http\Controllers\Admin\BranchController::class,
    'subscribers' => App\Http\Controllers\Admin\SubscribeController::class,
    'brands' => App\Http\Controllers\Admin\BrandController::class,
    'users' => App\Http\Controllers\Admin\UserController::class,
    'blogs' => App\Http\Controllers\Admin\BlogController::class, 
 
]);


Route::get('user-admins', [App\Http\Controllers\Admin\UserController::class,'admins']);

Route::group(['controller' => \App\Http\Controllers\Admin\OrderController::class, 'as' => 'orders.'], function () {
    Route::get('orders', 'index')->name('index');
    Route::get('orders/{order}/edit', 'edit')->name('edit');
    Route::post('orders/changeStatus', 'changeOrderStatus')->name('changeStatus');
    Route::post('orders/changeOrderPaymentStatus', 'changeOrderPaymentStatus')->name('changeOrderPaymentStatus');
    Route::get('order/{order}/invoice', 'orderInvoice')->name('invoice');
    Route::post('order/{order}/cancel', 'orderCancel')->name('cancel');
    Route::post('orders/filter', 'orderFilter')->name('filter');
    Route::post('order/delivery/{order}', 'OrderDelivey')->name('delivery');
});

Route::group(['prefix' => 'simple-request-orders', 'controller' => \App\Http\Controllers\Admin\SimpleRequestOrderController::class, 'as' => 'simple_request_orders.'], function () {
    Route::get('/', 'index')->name('index');
    Route::get('{simpleRequestOrder}/edit', 'edit')->name('edit');
    Route::delete('{simpleRequestOrder}', 'destroy')->name('destroy');
    Route::post('{simpleRequestOrder}/changeStatus', 'changeOrderStatus')->name('changeStatus');
    Route::post('{simpleRequestOrder}/changeOrderShipmentStatus', 'changeShipmentStatus')->name('changeShipmentStatus');

    Route::get('order/{simpleRequestOrder}/invoice', 'orderInvoice')->name('invoice');
    Route::post('order/{simpleRequestOrder}/cancel', 'orderCancel')->name('cancel');
    Route::post('orders/filter', 'orderFilter')->name('filter');
    Route::post('order/delivery/{simpleRequestOrder}', 'OrderDelivey')->name('delivery');
});

Route::group(['prefix' => 'contact-messages', 'controller' => \App\Http\Controllers\Admin\ContactMessageController::class, 'as' => 'contact_messages.'], function () {
    Route::get('/', 'index')->name('index');
    Route::get('show/{message}', 'show')->name('show');
    Route::delete('{message}', 'destroy')->name('destroy');
});

Route::group(['prefix' => 'commercial-requests', 'controller' => \App\Http\Controllers\Admin\CommercialRequestController::class, 'as' => 'commercial_requests.'], function () {
    Route::get('/', 'index')->name('index');
    Route::get('show/{message}', 'show')->name('show');
    Route::delete('{message}', 'destroy')->name('destroy');
});

Route::group(['prefix' => 'inspection-requests', 'controller' => \App\Http\Controllers\Admin\InspectionRequestController::class, 'as' => 'inspection_requests.'], function () {
    Route::get('/', 'index')->name('index');
    Route::get('show/{inspectionRequest}', 'show')->name('show');
    Route::delete('{inspectionRequest}', 'destroy')->name('destroy');
});

Route::group(['prefix' => 'reports', 'controller' => \App\Http\Controllers\Admin\ReportController::class, 'as' => 'reports.'], function () {
    Route::get('/', 'index')->name('index');
    Route::get('orders/generate', 'generate')->name('orders.generate');
    Route::get('orders/export','export')->name('orders.export');

});

Route::resource('seo-assistant', App\Http\Controllers\Admin\SeoAssistantController::class)
    ->only(['index', 'update'])
    ->names('seo_assistant');
