@extends('layouts.app')
@section('meta')
<title>{{ __('home.account_details') }}</title>
@endsection
@section('content')

<!-- page-title -->
<div class="tf-page-title">
    <div class="container">
        <div class="heading text-center">{{ __('home.account_details') }}</div>
    </div>
</div>
<!-- /page-title -->


<!-- page-cart -->
<section class="flat-spacing-11">
    <div class="container">
        <div class="row">
            <div class="col-lg-3">
                <div class="wrap-sidebar-account">
                    @include('website.userBoard.partials.account-nav')
                </div>
            </div>
            <div class="col-lg-9">
                <div class="my-account-content account-edit">
                    <div class="">
                        <form class="" id="form-password-change" action="{{ route('account.update') }}" method="post">
                            @csrf
                            <div class="tf-field style-1 mb_15">

                                <input class="tf-field-input tf-input @error('f_name') is-invalid @enderror" placeholder="{{ trans('home.f_name') }} " value="{{ auth()->user()->f_name }}" type="text" id="property1" name="f_name">
                                <label class="tf-field-label fw-4 text_black-2" for="property1">{{ trans('home.f_name')
                                    }}</label>

                                @error('f_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="tf-field style-1 mb_15">
                                <input class="tf-field-input tf-input @error('l_name') is-invalid @enderror" placeholder="{{ trans('home.l_name') }}* " value="{{ auth()->user()->l_name }}" type="text" id="property2" name="l_name">
                                <label class="tf-field-label fw-4 text_black-2" for="property2">{{ trans('home.l_name')
                                    }}*</label>

                                @error('l_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="tf-field style-1 mb_15">
                                <input class="tf-field-input tf-input @error('email') is-invalid @enderror" placeholder="{{ __('Email Address') }} " value="{{ auth()->user()->email }}" type="email" id="property3" name="email" autocomplete="email" required>
                                <label class="tf-field-label fw-4 text_black-2" for="property3">{{ __('Email Address')
                                    }} *</label>

                                @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="mb_20">
                                <button type="submit" class="tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center">Save
                                    Changes</button>
                            </div>
                        </form>
                        <form class="" id="form-password-change" action="{{ route('password.update') }}" method="post">
                            @csrf <!-- CSRF token for security -->

                            <h6 class="mb_20">Password Change</h6>

                            <!-- Current Password Field -->
                            <div class="tf-field style-1 mb_30">
                                <input class="tf-field-input tf-input" placeholder=" " type="password" id="current_password" name="current_password" required>
                                <label class="tf-field-label fw-4 text_black-2" for="current_password">Current Password</label>
                                @error('current_password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <!-- New Password Field -->
                            <div class="tf-field style-1 mb_30">
                                <input class="tf-field-input tf-input" placeholder=" " type="password" id="password" name="password" required>
                                <label class="tf-field-label fw-4 text_black-2" for="password">New Password</label>
                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <!-- Confirm New Password Field -->
                            <div class="tf-field style-1 mb_30">
                                <input class="tf-field-input tf-input" placeholder=" " type="password" id="password_confirmation" name="password_confirmation" required>
                                <label class="tf-field-label fw-4 text_black-2" for="password_confirmation">Confirm New Password</label>
                            </div>

                            <!-- Submit Button -->
                            <div class="mb_20">
                                <button type="submit" class="tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center">{{ __('Reset Password') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- page-cart -->
@endsection
@section('script')

@if($errors->any())
    <script>
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "positionClass": "toast-top-right"
        };
        @foreach ($errors->all() as $error)
            toastr.error("{{$error}}");
        @endforeach
    </script>
@endif
@endsection