@extends('layouts.app')
@section('meta')

@php echo $metatags @endphp
@php echo $schema @endphp
@endsection
@section('content')
{{-- Breadcrumb --}}
@include('website.product-partials._breadcrumb', ['page_title' => $product->name])

<section class="flat-spacing-4 pt-0">
    <div class="tf-main-product section-image-zoom">
        <div class="container">
            <div class="row" id="product-section">
                <div class="col-md-6">
                    <div class="tf-product-media-wrap sticky-top">
                        {{-- Product Media Section --}}
                        @include('website.product-partials._product-media', [
                        'product' => $product,
                        'images' => $product->variants->isNotEmpty() ? $product->default_variant->images :
                        $product->images,
                        'mainImage' => $product->main_image_path,
                        'mainImageAlt' => $product->alt_main_image
                        ])
                    </div>
                </div>
                {{-- Product Info --}}
                <div class="col-md-6">
                    <div class="tf-product-info-wrap position-relative">
                        <div class="tf-zoom-main"></div>
                        <div class="tf-product-info-list other-image-zoom">
                            <div class="tf-product-info-title">
                                <h5>{{ $product->name }}</h5>
                            </div>



                            {{-- Product Pricing --}}
                            @include('website.product-partials._product-pricing', [
                            'product' => $product,
                            'variantId' => $product->default_variant?->id
                            ])

                            {{-- Viewing Count --}}
                            @if($product->viewing_count > 3)
                            <div class="tf-product-info-liveview">
                                <div class="liveview-count">{{ $product->viewing_count }}</div>
                                <p class="fw-6">People are viewing this right now</p>
                            </div>
                            @endif

                            {{-- Short Description --}}
                            <div class="tf-product-info-liveview">
                                <p class="fw-6">{{ $product->short_text }}</p>
                            </div>


                            {{-- Variant Selector --}}
                            @if ($product->has_variants)
                            @include('website.product-partials._variant-selector', [
                            'product' => $product
                            ])
                            @endif

                            {{-- Quantity Selector --}}
                            <div class="tf-product-info-quantity">
                                <div class="quantity-title fw-6">Quantity</div>
                                <div class="wg-quantity">
                                    <span class="btn-quantity btn-decrease">-</span>
                                    <input type="text" class="quantity-product" name="quantity" value="1">
                                    <span class="btn-quantity btn-increase">+</span>
                                </div>
                            </div>

                            {{-- Action Buttons --}}

                        <div class="tf-product-info-buy-button">
                            <button type="button"
                                    class="tf-btn btn-fill justify-content-center fw-6 fs-16 flex-grow-1 animate-hover-btn btn-add-to-cart"
                                    data-product_id="{{ $product->id }}"
                                    @disabled($product->isInStock() == false)
                                    title="{{ $product->isInStock() == false ? 'Out of stock' : 'Add to cart' }}">
                                <span>{{ $product->isInStock() == false ? 'Out of stock' : 'Add to cart' }}</span>
                            </button>
                            <button type="button"
                                    data-product_id="{{ $product->id }}"
                                    class="tf-btn btn-fill justify-content-center fw-6 fs-16 flex-grow-1 animate-hover-btn btn-add-to-sample-request">
                                    <span>{{ __('home.Add sample Request') }}</span>
                            </button>
                            <button type="button"
                                    class="tf-product-btn-wishlist hover-tooltip box-icon bg_white wishlist btn-icon-action">
                                <span class="icon icon-heart"></span>
                                <span class="tooltip">Add to Wishlist</span>
                                <span class="icon icon-delete"></span>
                            </button>
                        </div>

                            {{-- Out of Stock Message --}}

                            {{-- Extra Links --}}
                            @include('website.product-partials._extra-links')

                            {{-- Delivery & Return Info --}}
                            @include('website.product-partials._delivery-return')

                            {{-- Trust Seal & Payment Methods --}}
                            @include('website.product-partials._trust-seal')

                        </div>
                    </div>
                </div>
            </div>
        </div>
</section>

        @include('website.product-partials._tabs');



        {{-- Related Products --}}
        @if($relatedProducts->isNotEmpty())
               @include('website.product-partials._related-products', ['relatedProducts' => $relatedProducts])
        @endif




@endsection

@section('script')
<script>
    $(document).ready(function() {
        // Initialize Swiper
        let thumbsSwiper = null;
        let mainSwiper = null;

        function initializeSwiper() {
            thumbsSwiper = new Swiper('.tf-product-media-thumbs', {
                direction: 'vertical'
                , slidesPerView: 'auto'
                , spaceBetween: 10
                , watchSlidesVisibility: true
                , watchSlidesProgress: true
            });
            mainSwiper = new Swiper('.tf-product-media-main', {
                slidesPerView: 1
                , spaceBetween: 10
                , thumbs: {
                    swiper: thumbsSwiper
                }
                , navigation: {
                    nextEl: '.thumbs-next'
                    , prevEl: '.thumbs-prev'
                }
            });
        }
        if ($('.tf-product-media-thumbs').length) {
            initializeSwiper();
        }

        // Function to bind variant change listener
        function bindVariantChangeListener() {
            $('input[name^="variant["]').off('change').on('change', function() {
                const form = $('#variant-form');
                const selectedValue = $(this).data('value');
                const attributeName = $(this).data('attribute');

                // Update label immediately
                $('.value-current-' + attributeName.toLowerCase()).text(selectedValue);

                const formData = form.serialize(); // Includes product_id, variant[attribute_id], number

                $.ajax({
                    url: form.attr('action')
                    , type: form.attr('method')
                    , data: formData
                    , dataType: 'json'
                    , success: function(response) {
                        if (response.error) {
                            console.error(response.error);
                            alert(response.error);
                            return;
                        }

                        // Update price display
                        updatePriceDisplay(response.variant);

                        // Update stock status
                        updateStockStatus(response.variant);



                        // Update attributes
                        if (response.variant.attributes) {
                            Object.keys(response.variant.attributes).forEach(attr => {
                                $('.value-current-' + attr.toLowerCase()).text(response.variant.attributes[attr]);
                            });
                        }

                        // Update images
                        if (response.variant.images && response.variant.images.length > 0) {

                            updateProductImages(response.variant.images);
                        }
                    }
                    , error: function(xhr, status, error) {

                        toastr.error(error);
                    }
                });
            });
        }

        function updatePriceDisplay(variant) {
            const priceContainer = $('.product-pricing');

            if (variant.is_on_sale) {
                priceContainer.html(`
                    <span class="sale-price">${variant.sale_price}</span>
                    <span class="original-price">
                        <del>${variant.price}</del>
                    </span>
                `);
            } else {
                priceContainer.html(`<span class="price">${variant.price}</span>`);
            }

            if (variant.is_on_sale) {
                priceContainer.html(`
                    <div class="sale-price">
                        <strong>Now:</strong> ${variant.currency} ${variant.sale_price}
                    </div>
                    <div class="original-price">
                        <strong>Before sale price:</strong>
                        <del>${variant.currency} ${variant.price}</del>
                    </div>
                    <div class="save-discount">
                        <strong>Save:</strong> ${variant.currency} ${variant.discount_amount}
                    </div>
                `);
                        } else {
                            priceContainer.html(`
                    <span class="price">
                        ${variant.currency} ${variant.price}
                    </span>
                `);
            }
            // Also update any other price elements that might exist
            $('.price-on-sale, .current-price').text(variant.sale_price || variant.price);
        }
        // Function to update product images
        function updateProductImages(images) {


            // Clear existing slides
            $('.tf-product-media-thumbs .swiper-wrapper').empty();
            $('.tf-product-media-main .swiper-wrapper').empty();

            // Add new slides
            images.forEach(image => {
                $('.tf-product-media-thumbs .swiper-wrapper').append(`
                <div class="swiper-slide stagger-item">
                    <div class="item">
                        <img class="lazyload" data-src="${image.src}" src="${image.src}" alt="${image.alt}">
                    </div>
                </div>
            `);
                $('.tf-product-media-main .swiper-wrapper').append(`
                <div class="swiper-slide">
                    <a href="${image.src}" target="_blank" class="item" data-pswp-width="770px" data-pswp-height="1075px">
                        <img class="tf-image-zoom lazyload" data-zoom="${image.src}"
                             data-src="${image.src}" src="${image.src}" alt="${image.alt}">
                    </a>
                </div>
            `);
            });

            // Reinitialize Swiper
            if (thumbsSwiper && mainSwiper) {
                thumbsSwiper.destroy(true, true);
                mainSwiper.destroy(true, true);
            }
            initializeSwiper();
        }

        // Function to bind quantity button listeners
        function bindQuantityListeners() {
            $('.btn-increase').off('click').on('click', function() {
                const input = $('.quantity-product');
                const value = parseInt(input.val());
                input.val(value + 1);
            });
            $('.btn-decrease').off('click').on('click', function() {
                const input = $('.quantity-product');
                const value = parseInt(input.val());
                if (value > 1) {
                    input.val(value - 1);
                }
            });
        }

        // Function to update stock status
        function updateStockStatus(variant) {

            const stockStatus = $('.stock-status');
            const addToCartButton = $('.btn-add-to-cart');
            const addToCartText = addToCartButton.find('span');

            if (variant.in_stock) {
                stockStatus.text('In Stock').removeClass('out-of-stock').addClass('in-stock');
                addToCartButton.prop('disabled', false).attr('title', 'Add to cart');
                addToCartText.text('Add to cart');
            } else {
                stockStatus.text('Out of Stock').removeClass('in-stock').addClass('out-of-stock');
                addToCartButton.prop('disabled', true).attr('title', 'Out of stock');
                addToCartText.text('Out of stock');
            }
        }

        // Initial binding
        bindVariantChangeListener();
        bindQuantityListeners();


    });

</script>
@endsection