@extends('layouts.app')
@section('meta')
@php echo $metatags @endphp
@php echo $schema @endphp
@endsection
@section('content')
@include('website._breadcrumb', ['page_title' =>  __('home.blogs') ])
<section class="flat-spacing-2">
    <div class="container">

        <div class="wrapper-control-shop">
            <div class="tf-grid-layout wrapper-shop tf-col-4" id="gridLayout">
                @forelse ($blogs as $blog)
                <div class="swiper-slide">
                    <div class="collection-item-v2 hover-img">
                        <a href="{{ route('website.blog.details', $blog->slug) }}" class="collection-inner">
                            <div class="collection-image img-style">
                                <img class="lazyload" data-src="{{ $blog->image_path }}" src="{{ $blog->image_path }}" alt="{{ $blog->name }}">
                            </div>
                            <div class="collection-content">
                                <div class="top wow fadeInUp" data-wow-delay="0s">
                                    <h5 class="heading">{{ $blog->name }}</h5>

                                </div>
                                <div class="bottom wow fadeInUp" data-wow-delay="0s">
                                    <button class="tf-btn btn-line collection-other-link fw-6"><span>{{ __('home.read_more') }}</span><i class="icon icon-arrow1-top-left"></i></button>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            
                @empty
                <p>{{ __('home.no_blogs') }}</p>

                @endforelse



            </div>

        </div>
    </div>
</section>
@endsection
