@extends('layouts.app')
<title> {{ config('site_app_name') }} @lang('home.login') </title>
@section('content')
<!-- page-title -->
<div class="tf-page-title style-2">
    <div class="container">
        <div class="heading text-center">{{ __('home.login') }}</div>
    </div>
</div>
<!-- /page-title -->

<section class="flat-spacing-10">
    <div class="container">
        <div class="tf-grid-layout lg-col-2 tf-login-wrap">
            <div class="tf-login-form">

                <div id="login">
                    <h5 class="mb_36">{{ __('home.login') }}</h5>
                    <div>
                        <form class="" id="login-form" action="{{ route('login') }}" accept-charset="utf-8" method="POST">

                            @csrf

                            <div class="tf-field style-1 mb_15">
                                <input class="tf-field-input tf-input @error('email') is-invalid @enderror" placeholder="{{ __('home.email  ') }}" type="email" id="property3" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                                <label class="tf-field-label fw-4 text_black-2" for="property3">{{ __('home.email') }}</label>

                                @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror

                            </div>

                            <div class="tf-field style-1 mb_30">
                                <input class="tf-field-input tf-input @error('password') is-invalid @enderror" placeholder="" type="password" id="property4" n name="password" required>
                                <label class="tf-field-label fw-4 text_black-2" for="property4">{{ __('home.password') }} *</label>

                                @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror

                            </div>

                            @if (Route::has('password.request'))
                            <div class="mb_20">
                                <a class="tf-btn btn-line" href="{{ route('password.request') }}">
                                    {{ __('home.Forgot your password?') }}
                                </a>
                            </div>

                        @endif
                            <div class="">
                                <button type="submit" class="tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center">{{ __('home.login') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="tf-login-content">
                <h5 class="mb_36">{{ __("home.I'm new here") }}</h5>
                <p class="mb_20">{{ __('home.login_text') }}</p>
                <a href="{{ route('register') }}" class="tf-btn btn-line">{{ __('home.register') }}<i class="icon icon-arrow1-top-left"></i></a>
            </div>
        </div>
    </div>
</section>
@endsection
