@extends('layouts.admin')
<title>{{trans('home.order_details')}}</title>

@section('content')



<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.order_details')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('simple_request_orders.index') }}">{{trans('home.simple_request_orders')}}</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.order_details')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    @if(session()->has('success'))
    <div class="alert alert-success">
        {{ session()->pull('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif

    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">

                    <div aria-multiselectable="true" class="accordion" id="accordion" role="tablist">
                        <div class="card">
                            <div class="card-header" id="headingOne" role="tab">
                                <a aria-controls="collapseOne" aria-expanded="true" data-toggle="collapse" href="#collapseOne" class="collapsed">{{trans('home.order_details')}}</a>
                            </div>
                            <div aria-labelledby="headingOne" class="collapse show" data-parent="#accordion" id="collapseOne" role="tabpanel" style="">
                                <div class="card-body">
                                    <div class="order_details">
                                        <div class="row">
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.tracking_code')}} :</strong>
                                                    {{$order->order_number}}</p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.order_date')}} :</strong> {{date('Y-m-d',
                                                    strtotime($order->created_at ))}}</p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.address')}} :</strong>
                                                    {{$order->address->full_address}}
                                                </p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{__('home.order_user')}} :</strong> {{$order->user->name}}
                                                </p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{__('home.Email Address')}} :</strong>
                                                    {{$order->user->email}}</p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{__('home.order_phone_numbers')}} :</strong>
                                                    {{$order->address?->phone}}</p>
                                            </div>

                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.payment_method')}} :</strong>
                                                    {{$order->payment->paymentMethod->name}}
                                                </p>
                                            </div>

                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.shipping_fees')}} :</strong>
                                                    {{ config('app.currency') }} {{$order->shipping_fees ?? 0}}</p>
                                            </div>
                                            {{-- <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.payment_fees')}} :</strong>
                                            {{$order->payment->paymentMethod->fees}}</p>
                                        </div> --}}


                                        <div class="col-sm-12 col-md-6">
                                            <p><strong>{{trans('home.total')}} :</strong> {{ config('app.currency')
                                                    }} {{$order->total_amount}} </p>
                                        </div>

                                        <div class="col-sm-12 col-md-6">
                                            <p><strong>{{trans('home.order_note')}} :</strong> {{$order->note}}</p>
                                        </div>
                                    </div>
                                </div>
                                <br>

                                <div class="table-responsive-sm order-table">
                                    <table class="bg-white table table-bordered table-hover text-center">
                                        <thead>
                                            <tr>
                                                <th class="text-left">Product Image</th>
                                                <th class="text-left">Product Name</th>
                                                <th class="text-left">Product Description</th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($order->items as $item)
                                            <tr>
                                                <td>
                                                    <a href="{{ route('product.details' , $item->product->id) }}" class="thumb">
                                                        @if($item->product_variant_id)
                                                        <img width="60px" class="checkout-image" src="{{ $item->product->defaultVariant->first_image  }}">
                                                        @else
                                                        <img width="60px" class="checkout-image" src="{{  $item->product->main_image_path }}">

                                                        @endif
                                                    </a>
                                                </td>
                                                <td class="text-left">
                                                    <a href="{{ route('product.details' , $item->product->link) }}" class="thumb">
                                                        {{ $item->product->name}}
                                                    </a>
                                                    {{-- Variant Attributes --}}
                                                    @if ($item->product_variant_id)

                                                    @foreach ($item->variant->values as $value)
                                                    <p>{{ $value->value->attribute->name }} : {{
                                                            $value->value->value }}</p>
                                                    @endforeach
                                                    @endif
                                                </td>
                                                <td>{{ $item->product->short_text}}</td>
                                            </tr>

                                            @empty
                                            <tr>
                                                <td colspan="5">{{trans('home.order_item_not_availbale_now')}}</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <br>

                <div>
                    <h6 class="card-title mb-1">{{trans('home.order_statusses')}}</h6>
                </div>

                <div class="form-wizard-steps order-tracking" style="justify-content: space-around;align-items: center;margin-top: 40px;">


                    @php
                    $iconMap = [
                    'Pending' => 'fa-unlock-alt',
                    'Shipped' => 'fa-check',
                    'In Transit'=> 'fa-recycle',
                    'Delivered' => 'fa-shipping-fast',
                    'Returned' => 'fa-undo',
                    'Cancelled' => 'fa-times',
                    ];
                    @endphp

                    @foreach($order_statuses as $order_status)
                 
                    @php
                    $statusName = $order_status->name;
                    $isCurrent = $order->status_id == $order_status->id;
                    $btnClass = $isCurrent ? 'btn-success' : 'btn-primary';
                    $iconClass = $iconMap[$statusName] ?? 'fa-handshake';
                    $imgSrc = url('resources/assets/back/img/' . ($statusImages[$statusName] ?? 'box.png'));
                    @endphp

                    <form action="{{ route('simple_request_orders.changeStatus' , $order->id) }}" method="POST">
                        @csrf
                        <div class="step-track" style="width: auto">
                            <input type="hidden" name="status_id" value="{{ $order_status->id }}">
                            <div class="step-icon">
                                <button type="submit" class="btn track-order {{ $btnClass }}">
                                    <img style="display:none;" src="{{ $imgSrc }}">
                                    <i class="fa {{ $iconClass }}"></i>
                                </button>
                            </div>
                            <p>{{ $statusName }}</p>
                        </div>
                    </form>

                    @endforeach

                </div>
                <br>

                <div>
                    <h6 class="card-title mb-1">{{trans('home.order_shipment')}}</h6>
                </div>

                <div class="form-wizard-steps order-tracking" style="justify-content: space-around;align-items: center;margin-top: 40px;">


                    @php
                    $iconMap = [
                    'Pending' => 'fa-unlock-alt',
                    'Shipped' => 'fa-check',
                    'In Transit'=> 'fa-recycle',
                    'Delivered' => 'fa-shipping-fast',
                    'Returned' => 'fa-undo',
                    'Cancelled' => 'fa-times',
                    ];
                    @endphp

                    @foreach($order_shipment_statuses as $order_shipment_status)
                    @php
                    $statusName = $order_shipment_status->name;
                    $isCurrent = $order->latestShipment?->order_shipment_status_id === $order_shipment_status->id;
                    $btnClass = $isCurrent ? 'btn-success' : 'btn-primary';
                    $iconClass = $iconMap[$statusName] ?? 'fa-handshake';
                    $imgSrc = url('resources/assets/back/img/' . ($statusImages[$statusName] ?? 'box.png'));
                    @endphp

                    <form action="{{ route('simple_request_orders.changeShipmentStatus' , $order->id) }}" method="POST">
                        @csrf
                        <div class="step-track" style="width: auto">
                            <input type="hidden" name="shipment_status_id" value="{{ $order_shipment_status->id }}">
                            <div class="step-icon">
                                <button type="submit" class="btn track-order {{ $btnClass }}">
                                    <img style="display:none;" src="{{ $imgSrc }}">
                                    <i class="fa {{ $iconClass }}"></i>
                                </button>
                            </div>
                            <p>{{ $statusName }}</p>
                        </div>
                    </form>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

</div>

@endsection
