@extends('layouts.admin')
<title>{{trans('home.order_report')}}</title>
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.order_report')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.order_report')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">
                    <h6 class="card-title mb-1">{{trans('home.order_report')}}</h6>
                    <hr>
                    <form action="{{  route('reports.orders.generate')}}" method="get" id="reportForm">
                       
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="start_date"> {{trans('home.from')}}</label>
                                <input type="date" class="form-control" name="start_date" id="start_date">
                            </div>

                            <div class="form-group col-md-6">
                                <label for="end_date"> {{trans('home.to')}}</label>
                                <input type="date" class="form-control" name="end_date" id="end_date">
                            </div>

                            <div class="form-group col-md-6">
                                <label for="min_amount"> {{trans('home.min_amount')}}</label>
                                <input type="text" class="form-control" name="min_amount" id="min_amount">
                            </div>

                            <div class="form-group col-md-6">
                                <label for="max_amount"> {{trans('home.max_amount')}}</label>
                                <input type="text" class="form-control" name="max_amount" id="max_amount">
                            </div>

                            <div class="form-group col-md-3">
                                <label for="paymentMethods">{{trans('home.payment_methods')}}</label>
                                <select class="form-control select2" name="payment_id" id="paymentMethods">
                                    <option value="null">Select Payment Method (optional)</option>
                                    @foreach($paymentMethods as $paymentMethod)
                                    <option value="{{$paymentMethod->id}}">{{ $paymentMethod->name }}</option>
                                    @endforeach
                                </select>
                            </div>


                            <div class="form-group col-md-3">
                                <label for="shippingMethod">{{trans('home.order_statuses')}}</label>
                                <select class="form-control select2" name="status_id" id="shippingMethod">
                                    <option value="null">Select Status (optional)</option>
                                    @foreach($orderStatuses as $orderStatus)
                                    <option value="{{$orderStatus->id}}">{{ $orderStatus->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            {{-- <div class="form-group col-md-3">
                                <label for="shippingMethod">{{trans('home.shipping_methods')}}</label>
                                <select class="form-control select2" name="shipping_id" id="shippingMethod">
                                    <option value="null">Select Shipment Status (optional)</option>
                                    @foreach($orderShipmentStatuses as $orderShipmentStatus)
                                    <option value="{{$orderShipmentStatus->id}}">{{ $orderShipmentStatus->name }}
                                    </option>
                                    @endforeach
                                </select>
                            </div> --}}



                            {{-- @if($brands->count() > 0)
                            <div class="form-group col-md-3">
                                <label for="brands">{{trans('home.brands')}}</label>
                                <select class="form-control select2" name="brand_id" id="brand">
                                    <option value="null">Select brand (optional)</option>
                                    @foreach($brands as $brand)
                                    <option value="{{$brand->id}}">{{(app()->getLocale() ==
                                        'en')?$brand->name_en:$brand->name_ar}}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif --}}

                            {{-- <div class="form-group col-md-3">
                                <label for="categories">{{trans('home.categories')}}</label>
                                <select class="form-control select2" name="category_id" id="category">
                                    <option value="null">Select Category (optional)</option>
                                    @foreach($categories as $category)
                                    <option value="{{$category->id}}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div> --}}

                           
                            {{-- <div class="form-group col-md-3">
                                <label for="products">{{trans('home.products')}}</label>
                                <select class="form-control select2" name="product_id" id="products">
                                    <option value="null"> Select Products (optional) </option>
                                    @foreach($products as $product)
                                    <option value="{{$product->id}}">{{ $product->name }}</option>
                                    @endforeach
                                </select>
                            </div> --}}


                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary" title="{{trans('home.search')}}"> {{
                                    __('home.apply') }}</button>

                                <button type="reset" class="btn btn-secondary" title="{{trans('home.reset')}}">{{trans('home.reset')}}</button>

                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    <div class="searchResult">
       
    </div>
</div>

@endsection
@section('script')

<script>
    $(document).ready(function() {
        $('#reportForm').on('submit', function(e) {
            e.preventDefault();
            
            $.ajax({
                url: $(this).attr('action'),
                type: $(this).attr('method'),
                data: $(this).serialize(),
                success: function(response) {
                    $('.searchResult').html(response);
                },
                error: function(xhr) {
                    toastr.error(xhr.responseJSON.message)
                   
                }
            });
        });
    });
    </script>
    
<script>
    $(document).on('click', '#exportBtn', function() {
    // Get current form filters
    const formData = $('#reportForm').serialize();
    const exportUrl = $(this).data('url') + '?' + formData;
    
    // Trigger download
    window.location.href = exportUrl;
});
</script>
@endsection
