<!-- Edit Modal for this Record -->
<div class="modal fade" id="editModal-{{ $value->id }}" tabindex="-1" role="dialog" aria-labelledby="editModal-{{ $value->id }}" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Edit Value') }} - {{ $value->id }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" action="{{ route('attributes.values.update',[$attribute->id,$value->id]) }}">
                    @csrf
                    @method('PATCH')

                    <div class="row">
                        <div class="form-group col-md-4">
                            <label>{{ __('dashboard.value_en') }}</label>
                            <input class="form-control" name="value_en" type="text" value="{{ $value->value_en }}" placeholder="{{ __('dashboard.value_en') }}">
                        </div>

                        <div class="form-group col-md-4">
                            <label>{{ __('dashboard.value_ar') }}</label>
                            <input class="form-control" name="value_ar" type="text" value="{{ $value->value_ar }}" placeholder="{{ __('dashboard.value_ar') }}">
                        </div>

                        @if($attribute->isColor())
                        <div class="form-group col-md-4">
                            <label>{{ __('dashboard.code') }}</label>
                            <input class="form-control" name="code" type="color" value="{{ $value->code }}" placeholder="{{ __('dashboard.code') }}">
                        </div>
                        @endif

                        <div class="form-group col-md-6">
                            <div class="d-flex flex-wrap gap-2">
                                
                                <input type="checkbox" id="switch-{{ $value->id }}" switch="none" name="status" value="1" {{ $value->status ? 'checked' : '' }} />
                                <label for="switch-{{ $value->id }}" data-on-label="{{ __('dashboard.yes') }}" data-off-label="{{ __('dashboard.no') }}" class="mb-0 mx-2">{{ __('dashboard.publish/unpublish') }}</label>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">{{ __('Save changes') }}</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
