<?php

namespace Database\Seeders;

use App\Models\AttributeValue;
use App\Models\Product;
use App\Models\ProductVariant;
use App\Models\VariantValue;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProductVariantSeeder extends Seeder
{
    public function run(): void
    {
        // Get all products with attributes in one query
        $products = Product::whereHas('attributes')->get();
        
        // Get attribute values in two efficient queries
        $colorValues = AttributeValue::whereHas('attribute', fn($q) => $q->where('name_en', 'Color'))->get();
        $chairQuantityValues = AttributeValue::whereHas('attribute', fn($q) => $q->where('name_en', 'Chair quantity'))->get();

        DB::transaction(function () use ($products, $colorValues, $chairQuantityValues) {
            foreach ($products as $product) {
                $rand = rand(1, 100);
                $variantCount = rand(1, 3);

                // Case 1: 65% chance - Color variants only
                if ($rand <= 65) {
                    for ($i = 0; $i < $variantCount; $i++) {
                        $variant = ProductVariant::create([
                            'product_id' => $product->id,
                            'additional_price' => rand(100, 10000) + (rand(0, 99) / 100),
                            'stock' => rand(1, 10),
                        ]);

                        VariantValue::create([
                            'variant_id' => $variant->id,
                            'value_id' => $colorValues->random()->id,
                        ]);
                    }
                } 
                // Case 2: 35% chance - Color + quantity variants
                else {
                    for ($i = 0; $i < $variantCount; $i++) {
                        $variant = ProductVariant::create([
                            'product_id' => $product->id,
                            'additional_price' => rand(100, 10000) + (rand(0, 99) / 100),
                            'stock' => rand(1, 10),
                        ]);

                        // Assign color
                        VariantValue::create([
                            'variant_id' => $variant->id,
                            'value_id' => $colorValues->random()->id,
                        ]);

                        // Assign quantity
                        VariantValue::create([
                            'variant_id' => $variant->id,
                            'value_id' => $chairQuantityValues->random()->id,
                        ]);
                    }
                }
            }
        });
    }
}