<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Step 1: Create parent categories (no parent_id)
        $parents = Category::factory()
            ->count(5)
            ->parent(null) // This will set parent_id to null
            ->create();

        // Step 2: Create subcategories for each parent
        foreach ($parents as $parent) {
            Category::factory()
                ->count(5) // Create 5 subcategories for each parent
                ->parent($parent->id)
                ->create();
        }
    }
}
