<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_shipments', function (Blueprint $table) {
            // Drop the existing foreign key on order_id
            $table->dropForeign(['order_id']);

            // Make order_id nullable and re-add the foreign key
            $table->unsignedBigInteger('order_id')->nullable()->change();
            $table->foreign('order_id')->references('id')->on('orders')->restrictOnDelete();

            // Add simple_request_order_id
            $table->foreignId('simple_request_order_id')
                ->nullable()
                ->after('order_id');

            $table->foreign('simple_request_order_id')
                ->references('id')
                ->on('simple_request_orders')
                ->nullOnDelete();
        });
    
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_shipments', function (Blueprint $table) {
            // Drop the new foreign key and column
            $table->dropForeign(['simple_request_order_id']);
            $table->dropColumn('simple_request_order_id');

            // Revert order_id back to not nullable
            $table->dropForeign(['order_id']);
            $table->unsignedBigInteger('order_id')->nullable(false)->change();
            $table->foreign('order_id')->references('id')->on('orders')->restrictOnDelete();
        });
    }
};
