<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_discounts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained('products')->onDelete('cascade');
            $table->foreignId('variant_id')->nullable()->constrained('product_variants')->onDelete('cascade');; // If apply_to is 'variant', store variant ID 
            $table->string('name')->nullable(); // Discount name like "Summer Sale", "Black Friday"
            $table->string('type')->comment('Type of discount: fixed or percentage'); // e.g., 'fixed' for a fixed amount off, 'percentage' for a percentage off
            $table->decimal('value', 10, 2); 
            $table->string('apply_to')->comment('Type of application: product or variant'); // Apply to entire product or specific variants
            $table->datetime('starts_at')->nullable();
            $table->datetime('expires_at')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_discounts');
    }
};
