<?php
namespace App\Traits\Website\Products;
trait ProductFilterTrait
{
    public static function applyFilters($query, $filters)
    {
        if (!empty($filters)) {
          
            foreach ($filters as $attributeId => $valueIds) {
                $query->whereHas('attributes.values', function ($query) use ($attributeId, $valueIds) {
                    $query->where('attribute_id', $attributeId)
                        ->whereIn('value_id', $valueIds);
                });
            }
        }

        return $query;
    }

    public static function applySorting($query, $sortBy)
    {
        if (!empty($sortBy)) {
            switch ($sortBy) {
                case 'featured':
                    $query->where('featured', 1);
                    break;

                case 'price-low-to-high':
                    $query->join('product_stock', 'products.id', '=', 'product_stock.product_id')
                          ->select('products.*')
                          ->orderBy('product_stock.price', 'asc');
                    break;

                case 'price-high-to-low':
                    $query->join('product_stock', 'products.id', '=', 'product_stock.product_id')
                          ->select('products.*')
                          ->orderBy('product_stock.price', 'desc');
                    break;

                case 'date-old-to-new':
                    $query->orderBy('id', 'asc');
                    break;

                case 'date-new-to-old':
                    $query->orderBy('id', 'desc');
                    break;

                default:
                    $query->orderBy('id', 'desc'); // Default fallback
                    break;
            }
        } else {
            // Default sorting if no sortBy is provided
            $query->orderBy('id', 'desc');
        }
        return $query;
    }
}
