<?php

namespace App\Traits\PlaceOrder;

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

trait HandleGuestUserTrait
{
    public static function execute($data)
    {
        $phone =  $data['country_code'] . ' ' . $data['phone'];

        $email = $data['email'] ?? 'guest_' . uniqid() . '@example.com';
        $data['email'] = $email;

        $user = User::firstOrCreate(
            ['email' => $data['email']], // Prevent duplicate guest accounts
            [
                'f_name' => $data['f_name'],
                'l_name' => $data['l_name'],
                'phone' =>  $phone ?? $data['phone'],
                'password' => Hash::make('password'),
                'is_guest' => 1,
            ]
        );
        Auth::login($user);
        return $user;
    }
}
