<?php

namespace App\Traits\Carts;

use App\Models\Cart;
use App\Models\Coupon;
use App\Models\GuestCart;
use Illuminate\Support\Str;


trait GuestCartTrait
{

    private function getGuestCart($coupon_code = null)
    {

        $session = $this->getOrGenerateGuestCartSession();

        return Cart::with(['items.product','items.variant.values.value.attribute','items.variant.images', 'coupon'])
            ->firstOrCreate(
                ['session_id' => $session],
                [
                    'session_id' => $session,
                    'coupon_id' => $coupon_code ? $this->checkCouponCodeGuest($coupon_code) : null
                ]
            );
    }

    private function getOrGenerateGuestCartSession()
    {
        if (!session()->has('cart_session')) {
            if ($existingCart = Cart::whereNotNull('session_id')->first()) {
                session(['cart_session' => $existingCart->session_id]);
            } else {
                session(['cart_session' => $this->generateUniqueName()]);
            }
        }
        return session('cart_session');
    }

    private function generateUniqueName()
    {
        return 'guest' . '-' . Str::uuid();
    }

    private function checkCouponCodeGuest($coupon_code)
    {
        if (is_null($coupon_code)) {
            return null;
        }
        if ($coupon = Coupon::where('code', $coupon_code)->first()) {
            return $coupon->id;
        };
        flasher()->addError(__('home.Sorry Coupon Not Found')); // Add error to Flasher
        return null;
    }
}
