<?php

namespace App\Services;

use App\Exports\OrdersReportExport;
use App\Models\Order;
use Maatwebsite\Excel\Facades\Excel;

class OrderReportService
{

    public function generateReport($filter)
    {
        $query =  Order::ByDateRange($filter['start_date'], $filter['end_date'])
            ->ByAmountRange($filter['min_amount'], $filter['max_amount'])
            ->ByStatus($filter['status_id'])
            
            ->ByPaymentMethod($filter['payment_id']);


        $orders = $query->with([
            'user',
            'status',
            'payment.paymentMethod',
            'address.governorate',
            'address.country',
            'items.product',
        ])->orderBy('created_at', 'desc')->get();


        return $orders;
    }


    public function exportToCsv($data)
    {
        return Excel::download(new OrdersReportExport($data), 'orders_report.csv');
    }
}
