<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductDiscount extends Model
{
    use HasFactory;
    protected $fillable = [
        'product_id',
        'name',
        'type', // 'fixed' or 'percentage'
        'value',
        'apply_to', // 'product' or 'variant'
        'variant_id', // JSON array of variant IDs if apply_to is 'variant'
        'starts_at',
        'expires_at',
        'is_active',
    ];
    public const TYPES = ['fixed', 'percentage'];

    protected $casts = [
        'value' => 'decimal:2',
        'variant_ids' => 'array',
        'starts_at' => 'datetime',
        'expires_at' => 'datetime',
        'is_active' => 'boolean',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function variant()
    {
        return $this->belongsTo(ProductVariant::class, 'variant_id');
    }

    
}

