<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Partner extends Model
{
    use HasFactory;

    protected $table = 'partners';
    
    protected $fillable = [
        'name_en',
        'name_ar',
        'logo',
        'short_desc_en',
        'short_desc_ar',
        'description_en',
        'description_ar',
        'slug_en',
        'slug_ar',
        'website',
        'order',
        'status',
    ];

    public function getLogoPathAttribute(){
        return $this->logo ?  Helper::uploadedImagesPath('partners',$this->logo) : Helper::noImage() ;
    }

    public function getNameAttribute()
    {
        return $this->{'name_' . Helper::getLang()};
    }
    public function getShortDescAttribute()
    {
        return $this->{'short_desc_' . Helper::getLang()};
    }
    public function getDescriptionAttribute()
    {
        return $this->{'description_' . Helper::getLang()};

    }

    public function scopeActive($query)
    {
        $query->whereStatus(1);
    }
    
}
