<?php

namespace App\Models;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use App\Models\Product;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Sitemap\Contracts\Sitemapable;
use Spatie\Sitemap\Tags\Url;

class Category extends Model implements Sitemapable
{
    use HasFactory;
    protected $table = 'categories';
    private $lang ;
    protected $fillable = [
        'name_ar',
        'name_en',
        'order',
        'parent_id',
        'text_ar',
        'text_en',
        'image',
        'icon',
        'status',
        'link_ar',
        'link_en',
        'meta_title_ar',
        'meta_title_en',
        'meta_description_ar',
        'meta_description_en',
        'index',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();

    }

    public function subcategories()
    {
        return $this->hasMany(Category::class,'parent_id')->with('subcategories');
    }

    public function parent()
    {
        return $this->belongsTo(Category::class,'parent_id');
    }

    public function getImagePathAttribute()
    {
        return $this->image ?  Helper::uploadedImagesPath('categories',$this->image)   : Helper::noImage() ;
    }


    public function getIconPathAttribute()
    {

        return $this->icon ?  Helper::uploadedImagesPath('categories',$this->icon)   : Helper::noImage() ;

    }

    public function getRouteKeyName(): string
    {
        if(!request()->is('*admin*')){

            return 'link_' . $this->lang;
        }

        return 'id';
    }


     public function products()
     {
        return $this->hasMany(Product::class)->inRandomOrder();
     }

     public function activeProducts(){
	    return $this->hasMany(Product::class)->whereStatus(1)->inRandomOrder();
	}

     public function getNameAttribute(){
        return $this->{'name_'.$this->lang} ;
    }

    public function getTextAttribute(){
        return $this->{'text_'.$this->lang} ;
    }

    public function getLinkAttribute(){
        return $this->{'link_'.$this->lang} ;
    }


    public function getParentNameAttribute(){
        return  $this->parent?->name ?? trans('home.main_category');
    }

    public function getParentTextAttribute(){
        return $this->parent?->text ;

    }

    public function getParentLinkAttribute(){
        return  $this->parent?->link  ;
    }



    public function getActiveAttribute(){
        $this->status ? __('home.yes') : __( 'home.no') ;
     }

     public function scopeActive($query){
         $query->whereStatus(1);
      }

      public function scopeUnactive($query){
         $query->whereStatus(0);
      }

    public function getMetaTitleAttribute()
    {
        return $this->{'meta_title_' . $this->lang} ?? $this->name;
    }

    public function getMetaDescriptionAttribute()
    {
        return $this->{'meta_description_' . $this->lang} ?? $this->text;
    }

    public function toSitemapTag(): Url | string | array
    {
          // Return with fine-grained control:
          return Url::create(route('website.category.products', $this->link))
          ->setLastModificationDate(Carbon::create($this->updated_at))
          ->setChangeFrequency(Url::CHANGE_FREQUENCY_YEARLY)
          ->setPriority(0.5);
    }

}
