<?php

namespace App\Http\Requests\Admin\ProductsVariants;

use Illuminate\Foundation\Http\FormRequest;

class UpdateVariantRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            // 'value_id' => ['required', 'integer', 'exists:attribute_values,id'],
            'additional_price' => 'required|numeric|min:0',
            'stock' => 'required|integer|min:0',
            'value_ids' => 'required|array',
            'value_ids.*' => 'integer|exists:attribute_values,id',

        ];
    }
}
