<?php

namespace App\Http\Controllers;

use App\Models\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PaymobCallbackController extends Controller
{
    public function handleCallback(Request $request)
    {
        Log::info('Paymob Callback Received:', ['data' => $request->all()]);

        $callbackData = $request->all();

        if (!isset($callbackData['merchant_order_id']) || !isset($callbackData['success'])) {
            Log::error('Incomplete callback data received.', ['callbackData' => $callbackData]);
            return response()->json(['error' => 'Incomplete callback data'], 400);
        }

        $merchantOrderId = $callbackData['merchant_order_id'];
        $isSuccess = filter_var($callbackData['success'], FILTER_VALIDATE_BOOLEAN);
        $isVoided = filter_var($callbackData['is_voided'], FILTER_VALIDATE_BOOLEAN);
        $isRefunded = filter_var($callbackData['is_refunded'], FILTER_VALIDATE_BOOLEAN);
        // Find the order in the database
        $orderId = explode('-', $merchantOrderId)[0]; // Extract only the order ID
        $order = Order::find($orderId);


        if (!$order) {
            Log::error('Order not found for merchant_order_id:', ['merchant_order_id' => $merchantOrderId]);
            return response()->json(['error' => 'Order not found'], 404);
        }

        // Update the order status based on the callback
        if ($isSuccess && !$isVoided && !$isRefunded) {
            $order->update(['payment_status' => 'paid']);
            Log::info('Order marked as paid:', ['order_id' => $order->id]);
        } elseif ($isVoided) {
            $order->update(['payment_status' => 'voided']);
            Log::info('Order marked as voided:', ['order_id' => $order->id]);
        } elseif ($isRefunded) {
            $order->update(['payment_status' => 'refunded']);
            Log::info('Order marked as refunded:', ['order_id' => $order->id]);
        } else {
            $order->update(['payment_status' => 'failed']);
            Log::info('Order marked as failed:', ['order_id' => $order->id]);
        }


        return view('website.order-thank',compact('order'));
    }
}