<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\OrderShipment;
use App\Models\OrderShipmentStatus;
use App\Models\OrderStatus;
use App\Models\SimpleRequestOrder;
use Illuminate\Http\Request;

class SimpleRequestOrderController extends Controller
{
    public function index()
    {
        $data['orders'] = SimpleRequestOrder::with([
            'user',
            'status',
            'payment.paymentMethod',
            'address.governorate',
            'address.country',
            'items.product',
            'latestShipment.shipmentStatus'
            
        ])
            ->orderBy('created_at', 'desc')
            ->get();

        return view('admin.simple_request_orders.index', $data);
    }

    public function destroy(SimpleRequestOrder $simpleRequestOrder)
    {
      
        $simpleRequestOrder->delete();

        return redirect()->route('simple_request_orders.index')->with('success', __('Order deleted successfully.'));
    }

    public function edit(SimpleRequestOrder $simpleRequestOrder)
    {
      
        $data['order'] = $simpleRequestOrder->load([
            'user',
            'status',
            'payment.paymentMethod',
            'address.governorate',
            'address.country',
            'items.product',
        ]);
        $data['order_statuses'] = OrderStatus::all();
        $data['order_shipment_statuses'] = OrderShipmentStatus::all();

        return view('admin.simple_request_orders.edit', $data);
    }

    public function changeOrderStatus(Request $request, SimpleRequestOrder $simpleRequestOrder)
    {
        $request->validate([
            'status_id' => 'required|exists:order_statuses,id',
        ]);

        $simpleRequestOrder->status_id = $request->status_id;
        $simpleRequestOrder->save();

        return redirect()->back()->with('success', __('Order status updated successfully.'));
    }

    public function changeShipmentStatus(Request $request, SimpleRequestOrder $simpleRequestOrder)
    {
        $request->validate([
            'shipment_status_id' => 'required|exists:order_shipment_statuses,id',
            'tracking_number' => 'nullable|string',
            'carrier' => 'nullable|string',
        ]);
    
        // Create or update shipment record
        OrderShipment::updateOrCreate(
            [
                'simple_request_order_id' => $simpleRequestOrder->id,
                'order_shipment_status_id' => $request->shipment_status_id,
            ],
            [
                'order_shipment_status_id' => $request->shipment_status_id,
                'tracking_number' => $request->tracking_number,
                'carrier' => $request->carrier,
                'shipped_at' => $request->shipment_status_id == 2 ? now() : null, // Assuming status 2 = shipped
                'delivered_at' => $request->shipment_status_id == 4 ? now() : null, // Assuming status 3 = delivered
            ]
        );
    
        return redirect()->back()->with('success', __('Shipment status updated successfully.'));
    }
}
