<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CommercialRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CommercialRequestController extends Controller
{
    public function index()
    {

        $contactUsMessages = CommercialRequest::orderBy('created_at', 'desc')->get();

        return view('admin.commercialRequests.index', compact('contactUsMessages'));
    }
    public function show(CommercialRequest $message)
    {
        return view('admin.commercialRequests.show', compact('message'));
    }

    public function destroy(Request $request)
    {
    
    
        // Validate the request
        $request->validate([
            'id' => 'required|array|min:1',
            'id.*' => 'integer|exists:commercial_requests,id',
        ]);
    
        $selectedIds = $request->input('id');
    
        DB::beginTransaction();
        try {
           
            // Delete the messages
            $deleted = CommercialRequest::whereIn('id', $selectedIds)->delete();
    
            DB::commit();
    
            // Handle AJAX requests
            if ($request->ajax()) {
                return response()->json([
                    'success' => true,
                    'message' => __('dashboard.your_items_deleted_successfully'),
                ]);
            }
    
            // Redirect for non-AJAX requests
            return redirect()->route('dashboard.contact_messages.index')
                ->with('success', __('dashboard.your_items_deleted_successfully'));
    
        } catch (\Exception $e) {
            DB::rollBack();
    
            // Log the error for debugging
            \Log::error('Error deleting contact messages: ' . $e->getMessage());
    
            // Handle AJAX requests
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => __('dashboard.an_error_occurred'),
                ], 500);
            }
    
            // Redirect for non-AJAX requests
            return redirect()->back()
                ->withErrors(__('dashboard.an_error_occurred'));
        }
    }
}
