<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Governorate;
use App\Models\Area;
use Illuminate\Http\Request;

class AreaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(){
        $this->middleware(['permission:areas']);
    }

    public function index()
    {
        //
        $areas = Area::orderBy('id','DESC')->with(['Governorate'])->get();
        return view('admin.areas.areas',compact('areas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $Governorates = Governorate::where('status',1)->get();
        return view('admin.areas.addArea',compact('Governorates'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();

        Area::create($data);

        return redirect('admin/areas')->with('success',trans('home.your_item_added_successfully'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $area=Area::find($id);
        if($area){
            $Governorates = Governorate::where('status',1)->get();
            return view('admin.areas.editArea',compact('Governorates','area'));
        }else{
            abort('404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $add = Area::find($id); 

        $data = $request->all();

        if (isset($data['status'])) {
            $data['status'] = 1;
        } else {
            $data['status'] = 0;
        }
        $add->update($data);

        return redirect('admin/areas')->with('success',trans('home.your_item_updated_successfully'));
    }


    public function destroy($ids)
    {

        //
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        $area = Area::whereIn('id',$ids)->CheckBeforDelete()->get();
        // dd($categories, $ids);
        if(count($area) > 0){
            if (request()->ajax()) {
                return response()->json(['message'=>__('home.the item cannot be deleted. There is data related to it')],402);
            }
            return redirect()->back()->withErrors(__('home.the item cannot be deleted. There is data related to it'));
        }

        foreach ($ids as $id) {
            $area = Area::findOrFail($id)->delete();
        }
    }

}
