<?php

namespace App\Helpers;

use Exception;
use Illuminate\Http\UploadedFile;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;

class Media
{
    // Make storeImage static
    public static function uploadAndAttachImage($imageFile, $folder = 'uploads')
    {
        try {
            // Generate a unique filename
            $filename = $imageFile->hashName();
    
            // Define the full path
            $path = "{$folder}/{$filename}";
    
            // Create and encode the image
            $image = Image::make($imageFile)->encode();
    
            // Store the image in the public disk
            Storage::disk('public')->put($path, $image);
    
            return $filename;
        } catch (\Exception $e) {
            throw new \Exception("Error storing image: " . $e->getMessage());
        }
    }

    public static function removeFile($folder, $file)
    {
        $path = "{$folder}/{$file}";

        if (Storage::disk('public')->exists($path)) {
            try {
                Storage::disk('public')->delete($path);
            } catch (\Exception $e) {
                throw new \Exception("Failed to delete {$file}: " . $e->getMessage());
            }
        }
    }

     /**
     * Generate a fake uploaded file for testing (new reusable method)
     */
    public static function generateFakeUploadedFile(
        string $prefix = 'item',
        int $width = 640,
        int $height = 480,
        string $extension = 'webp'
    ): UploadedFile {
        $tempPath = tempnam(sys_get_temp_dir(), $prefix) . '.' . $extension;
        
        // Get image content (with retry logic)
        $imageContent = false;
        $attempts = 0;
        
        while ($imageContent === false && $attempts < 3) {
            $imageContent = @file_get_contents(
                "https://picsum.photos/{$width}/{$height}?random=" . rand(1, 1000)
            );
            $attempts++;
        }

        if ($imageContent === false) {
            throw new Exception("Failed to download fake image after 3 attempts");
        }

        file_put_contents($tempPath, $imageContent);

        return new UploadedFile(
            $tempPath,
            "{$prefix}_" . uniqid() . ".{$extension}",
            "image/{$extension}",
            null,
            true // Test mode
        );
    }

    // public static function uploadAndAttachFile($file, $folder, $username = 'user')
    // {
    //     try {
    //         $filename = "{$username}-" . hexdec(uniqid()) . '.' . $file->getClientOriginalExtension();

    //         Storage::disk('public')->putFileAs($folder, $file, $filename);

    //         return $filename;
    //     } catch (\Exception $e) {
    //         throw $e;
    //     }
    // }
}
